/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.ssl;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.ssl.SSLTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ProviderTest
extends SSLTestBase {
    @Test
    public void testDumpDefaultProviders() throws Exception {
        ProviderTest.removeAllConfigurableProviders();
        System.out.println();
        System.out.println("Available Security providers:");
        ArrayList<Provider> supportTLS = new ArrayList<Provider>();
        for (Provider p : Security.getProviders()) {
            System.out.println("- " + String.valueOf(p));
            try {
                SSLContext.getInstance("TLS", p);
                supportTLS.add(p);
            }
            catch (NoSuchAlgorithmException e) {
                // empty catch block
            }
        }
        System.out.println();
        System.out.println("Available Security providers that support TLS:");
        for (Provider p : supportTLS) {
            System.out.println("- " + String.valueOf(p));
        }
        System.out.println();
    }
}

