/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.domain;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketCapabilityRequirement;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.SocketTestBase;
import org.newsclub.net.unix.domain.AFUNIXAddressSpecifics;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNIX_DOMAIN, AFSocketCapability.CAPABILITY_ABSTRACT_NAMESPACE})
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION", "NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"})
public class AbstractNamespaceTest
extends SocketTestBase<AFUNIXSocketAddress> {
    public AbstractNamespaceTest() {
        super(AFUNIXAddressSpecifics.INSTANCE);
    }

    private void testBind(AFUNIXSocketAddress addr) throws Exception {
        this.testBind(addr, addr);
    }

    private void testBind(AFUNIXSocketAddress addr, AFUNIXSocketAddress expected) throws Exception {
        try (AFUNIXServerSocket serverSocket = (AFUNIXServerSocket)this.newServerSocket();){
            serverSocket.bind((SocketAddress)addr);
            CompletableFuture<AFUNIXSocketAddress> cf = CompletableFuture.supplyAsync(() -> {
                AFUNIXSocket socket;
                try {
                    socket = AFUNIXSocket.connectTo((AFUNIXSocketAddress)addr);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                return (AFUNIXSocketAddress)socket.getRemoteSocketAddress();
            });
            AFUNIXSocket accept = serverSocket.accept();
            Assertions.assertEquals((Object)accept.getLocalSocketAddress(), (Object)cf.get());
            Assertions.assertEquals((Object)expected, (Object)cf.get());
        }
    }

    @Test
    public void testBind() throws Exception {
        this.testBind(AFUNIXSocketAddress.inAbstractNamespace((String)("juxtest-" + String.valueOf(UUID.randomUUID()))));
    }

    @Test
    public void testBindTrailingZeroes() throws Exception {
        this.testBind(AFUNIXSocketAddress.of((byte[])new byte[]{0, 10, 0}));
        this.testBind(AFUNIXSocketAddress.of((byte[])new byte[]{0, 10, 0, 0}));
        this.testBind(AFUNIXSocketAddress.of((byte[])new byte[]{0, 74, 0, 85}));
        this.testBind(AFUNIXSocketAddress.of((byte[])new byte[]{0, 0, 0}), null);
    }

    @Test
    public void testBindLongAbstractAddress() throws Exception {
        byte[] addr = new byte[108];
        addr[1] = 49;
        addr[79] = 88;
        this.testBind(AFUNIXSocketAddress.of((byte[])addr));
    }
}

