/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.domain;

import com.kohlschutter.testutil.AvailabilityRequirement;
import java.io.File;
import java.net.SocketAddress;
import java.net.UnixDomainSocketAddress;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.SocketTestBase;
import org.newsclub.net.unix.domain.AFUNIXAddressSpecifics;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class UnixDomainSocketAddressTest
extends SocketTestBase<AFUNIXSocketAddress> {
    public UnixDomainSocketAddressTest() {
        super(AFUNIXAddressSpecifics.INSTANCE);
    }

    @Test
    @AvailabilityRequirement(classes={"java.net.UnixDomainSocketAddress"}, message="This test requires Java 16 or later")
    public void testConvertUnixDomainSocketAddress() throws Exception {
        File f = new File("/tmp/hello");
        UnixDomainSocketAddress addr = UnixDomainSocketAddress.of(f.getPath());
        AFUNIXSocketAddress usa = AFUNIXSocketAddress.of((SocketAddress)addr);
        Assertions.assertEquals((Object)f, (Object)usa.getFile());
    }
}

