/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.rmi.AFSocketCapabilityRequirement;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AFSocketCapabilityCondition
implements ExecutionCondition {
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        AFSocketCapabilityRequirement requirement;
        AFSocketCapability[] requiredCapabilities = new AFSocketCapability[]{};
        Optional element = context.getElement();
        if (element.isPresent() && (requirement = ((AnnotatedElement)element.get()).getAnnotation(AFSocketCapabilityRequirement.class)) != null) {
            requiredCapabilities = requirement.value();
        }
        ArrayList<AFSocketCapability> unsupported = new ArrayList<AFSocketCapability>(requiredCapabilities.length);
        for (AFSocketCapability capability : requiredCapabilities) {
            if (AFSocket.supports(capability)) continue;
            unsupported.add(capability);
        }
        ConditionEvaluationResult result = unsupported.isEmpty() ? ConditionEvaluationResult.enabled((String)("All capability requirements met: " + Arrays.toString((Object[])requiredCapabilities))) : ConditionEvaluationResult.disabled((String)("Missing capabilities: " + String.valueOf(unsupported)));
        return result;
    }
}

