/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.testutil.TestAbortedWithImportantMessageException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.SocketTestBase;
import org.opentest4j.AssertionFailedError;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
public abstract class AcceptTimeoutTest<A extends SocketAddress>
extends SocketTestBase<A> {
    private static final int TIMING_INACCURACY_MILLIS = 5000;

    protected AcceptTimeoutTest(AddressSpecifics<A> asp) {
        super(asp);
    }

    @Test
    public void testCatchTimeout() throws Exception {
        int timeoutMillis = 500;
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(2500L), () -> {
            try (ServerSocket sock = this.startServer();){
                long time = System.currentTimeMillis();
                sock.setSoTimeout(500);
                long actualTimeout = sock.getSoTimeout();
                if (actualTimeout == 0L && "z/OS".equals(System.getProperty("os.name"))) {
                    return;
                }
                Assertions.assertTrue((Math.abs(500L - actualTimeout) <= 5000L ? 1 : 0) != 0, (String)("We should roughly get the same timeout back that we set before, but was " + actualTimeout + " instead of 500"));
                try (Socket socket = sock.accept();){
                    Assertions.fail((String)("Did not receive " + SocketTimeoutException.class.getName() + "; socket=" + String.valueOf(socket)));
                }
                catch (SocketException | SocketTimeoutException e) {
                    time = System.currentTimeMillis() - time;
                    Assertions.assertTrue((Math.abs(time - 500L) <= 5000L ? 1 : 0) != 0, (String)("Timeout not properly honored. Exception thrown after " + time + "ms vs. expected 500ms"));
                }
            }
        });
    }

    @Test
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    public void testTimeoutAfterDelay() throws Exception {
        int timeoutMillis = 5000;
        final AtomicBoolean keepRunning = new AtomicBoolean(true);
        CompletableFuture<Object> serverAddressCF = new CompletableFuture<Object>();
        try {
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(10000L), () -> {
                try (ServerSocket serverSock = this.startServer();){
                    final int connectDelayMillis = 50;
                    serverSock.setSoTimeout(5000);
                    long actualTimeout = serverSock.getSoTimeout();
                    if (actualTimeout == 0L && "z/OS".equals(System.getProperty("os.name"))) {
                        return;
                    }
                    Assertions.assertTrue((Math.abs(5000L - actualTimeout) <= 10L ? 1 : 0) != 0, (String)("We should roughly get the same timeout back that we set before, but was " + actualTimeout + " instead of 5000"));
                    final AtomicBoolean accepted = new AtomicBoolean(false);
                    final CompletableFuture runtimeExceptionCF = new CompletableFuture();
                    final SocketAddress serverAddress = serverSock.getLocalSocketAddress();
                    serverAddressCF.complete(serverAddress);
                    new Thread(){
                        private final Socket socket;
                        {
                            this.socket = AcceptTimeoutTest.this.newSocket();
                            this.setDaemon(true);
                        }

                        @Override
                        public void run() {
                            int i = 0;
                            while (keepRunning.get()) {
                                ++i;
                                try {
                                    Thread.sleep(connectDelayMillis);
                                }
                                catch (InterruptedException e) {
                                    return;
                                }
                                try {
                                    AcceptTimeoutTest.this.connectSocket(this.socket, serverAddress);
                                    runtimeExceptionCF.complete(null);
                                    break;
                                }
                                catch (SocketTimeoutException e) {
                                    if (!keepRunning.get()) {
                                        return;
                                    }
                                    System.out.println("SocketTimeout, trying connect again (" + i + ")");
                                }
                                catch (TestAbortedWithImportantMessageException e) {
                                    runtimeExceptionCF.complete(e);
                                    break;
                                }
                                catch (IOException e) {
                                    if (accepted.get()) break;
                                    e.printStackTrace();
                                    break;
                                }
                            }
                        }
                    }.start();
                    long time = System.currentTimeMillis();
                    try (Socket socket = serverSock.accept();){
                        Assertions.assertNotNull((Object)socket);
                        accepted.set(true);
                    }
                    time = System.currentTimeMillis() - time;
                    RuntimeException re = (RuntimeException)runtimeExceptionCF.get();
                    if (re != null) {
                        throw re;
                    }
                    Assertions.assertTrue((time >= 50L && (time < 5000L || time - 50L <= 5000L) ? 1 : 0) != 0, (String)("Timeout not properly honored. Accept succeeded after " + time + "ms vs. expected 5000ms"));
                }
            });
        }
        catch (AssertionFailedError e) {
            String msg = this.checkKnownBugAcceptTimeout(serverAddressCF.getNow(null));
            if (msg == null) {
                throw e;
            }
            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_WITH_ISSUES, msg, (Throwable)e);
        }
        finally {
            keepRunning.set(false);
        }
    }

    protected String checkKnownBugAcceptTimeout(SocketAddress serverAddr) {
        return null;
    }

    @Test
    public void testAcceptWithoutBindToService() throws Exception {
        ServerSocket ss = this.newServerSocket();
        Assertions.assertThrows(SocketException.class, () -> ss.accept());
    }
}

