/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import java.io.IOException;
import java.rmi.NoSuchObjectException;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.rmi.RemoteCloseable;
import org.newsclub.net.unix.rmi.RemoteCloseableThing;
import org.newsclub.net.unix.rmi.TestBase;
import org.newsclub.net.unix.rmi.TestService;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class RemoteCloseableTest
extends TestBase {
    @Test
    public void testRemoteCloseableWithACloseableThing() throws Exception {
        RemoteCloseableThing.IsCloseable testCloseable;
        RemoteCloseable<RemoteCloseableThing.IsCloseable> remoteCloseable2;
        TestService svc = this.lookupTestService();
        svc.remoteCloseableThingResetNumberOfCloseCalls(RemoteCloseableThing.IsCloseable.class);
        try {
            remoteCloseable2 = svc.remoteCloseable(RemoteCloseableThing.IsCloseable.class);
            try {
                testCloseable = (RemoteCloseableThing.IsCloseable)remoteCloseable2.get();
                try {
                    Assertions.assertEquals((int)0, (int)svc.remoteCloseableThingNumberOfCloseCalls(RemoteCloseableThing.IsCloseable.class));
                    remoteCloseable2.close();
                    Assertions.assertEquals((int)1, (int)svc.remoteCloseableThingNumberOfCloseCalls(RemoteCloseableThing.IsCloseable.class));
                    Assertions.assertThrows(NoSuchObjectException.class, () -> remoteCloseable2.close());
                }
                finally {
                    if (testCloseable != null) {
                        testCloseable.close();
                    }
                }
            }
            finally {
                if (remoteCloseable2 != null) {
                    remoteCloseable2.close();
                }
            }
        }
        catch (NoSuchObjectException remoteCloseable2) {
            // empty catch block
        }
        Assertions.assertEquals((int)1, (int)svc.remoteCloseableThingNumberOfCloseCalls(RemoteCloseableThing.IsCloseable.class));
        remoteCloseable2 = svc.remoteCloseable(RemoteCloseableThing.IsCloseable.class);
        try {
            testCloseable = (RemoteCloseableThing.IsCloseable)remoteCloseable2.get();
            if (testCloseable != null) {
                testCloseable.close();
            }
        }
        finally {
            if (remoteCloseable2 != null) {
                remoteCloseable2.close();
            }
        }
        Assertions.assertEquals((int)2, (int)svc.remoteCloseableThingNumberOfCloseCalls(RemoteCloseableThing.IsCloseable.class));
    }

    @Test
    public void testRemoteCloseableWithANotCloseableThing() throws Exception {
        RemoteCloseable<RemoteCloseableThing.NotCloseable> remoteCloseable2;
        TestService svc = this.lookupTestService();
        svc.remoteCloseableThingResetNumberOfCloseCalls(RemoteCloseableThing.NotCloseable.class);
        try {
            remoteCloseable2 = svc.remoteCloseable(RemoteCloseableThing.NotCloseable.class);
            try {
                @NonNull RemoteCloseableThing testNotCloseable = (RemoteCloseableThing)remoteCloseable2.get();
                Objects.requireNonNull(testNotCloseable.toString());
                Assertions.assertEquals((int)0, (int)svc.remoteCloseableThingNumberOfCloseCalls(RemoteCloseableThing.NotCloseable.class));
                remoteCloseable2.close();
                Assertions.assertEquals((int)0, (int)svc.remoteCloseableThingNumberOfCloseCalls(RemoteCloseableThing.NotCloseable.class));
                Assertions.assertThrows(NoSuchObjectException.class, () -> remoteCloseable2.close());
            }
            finally {
                if (remoteCloseable2 != null) {
                    remoteCloseable2.close();
                }
            }
        }
        catch (NoSuchObjectException remoteCloseable2) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)svc.remoteCloseableThingNumberOfCloseCalls(RemoteCloseableThing.NotCloseable.class));
        remoteCloseable2 = svc.remoteCloseable(RemoteCloseableThing.NotCloseable.class);
        if (remoteCloseable2 != null) {
            remoteCloseable2.close();
        }
        Assertions.assertEquals((int)0, (int)svc.remoteCloseableThingNumberOfCloseCalls(RemoteCloseableThing.NotCloseable.class));
    }
}

