/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFUNIXServerSocket;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AFUNIXServerSocketTest {
    @Test
    public void testSupported() throws Exception {
        Assertions.assertTrue((boolean)AFUNIXServerSocket.isSupported());
    }

    @Test
    public void testCloseable() throws Exception {
        final AtomicBoolean closed = new AtomicBoolean(false);
        Closeable closeable = new Closeable(){

            @Override
            public void close() throws IOException {
                closed.set(true);
            }
        };
        try (AFUNIXServerSocket socket = AFUNIXServerSocket.newInstance();){
            socket.addCloseable(null);
            socket.addCloseable(closeable);
            socket.removeCloseable(null);
            socket.removeCloseable(closeable);
        }
        Assertions.assertFalse((boolean)closed.get());
        socket = AFUNIXServerSocket.newInstance();
        try {
            socket.addCloseable(closeable);
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
        Assertions.assertTrue((boolean)closed.get());
    }

    @Test
    public void testBindBadArguments() throws Exception {
        try (AFUNIXServerSocket sock = AFUNIXServerSocket.newInstance();){
            Assertions.assertFalse((boolean)sock.isBound());
            Assertions.assertThrows(IllegalArgumentException.class, () -> sock.bind(null));
            Assertions.assertFalse((boolean)sock.isBound());
        }
        sock = AFUNIXServerSocket.newInstance();
        try {
            Assertions.assertFalse((boolean)sock.isBound());
            Assertions.assertThrows(IllegalArgumentException.class, () -> sock.bind((SocketAddress)new InetSocketAddress("", 0)));
            Assertions.assertFalse((boolean)sock.isBound());
        }
        finally {
            if (sock != null) {
                sock.close();
            }
        }
    }

    @Test
    public void testUnboundServerSocket() throws IOException {
        try (AFUNIXServerSocket socket = AFUNIXServerSocket.newInstance();){
            Assertions.assertTrue((socket.getReceiveBufferSize() > 0 ? 1 : 0) != 0);
        }
    }
}

