/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.File;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFUNIXDatagramSocket;
import org.newsclub.net.unix.AFUNIXDatagramUtil;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketCapability;
import org.newsclub.net.unix.AFUNIXSocketCapabilityRequirement;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@AFUNIXSocketCapabilityRequirement(value={AFUNIXSocketCapability.CAPABILITY_DATAGRAMS})
public class AFUNIXDatagramSocketTest {
    private static void assertUnconnectedDatagramSocket(AFUNIXDatagramSocket ds) {
        Assertions.assertFalse((boolean)ds.isClosed());
        Assertions.assertFalse((boolean)ds.isConnected());
        Assertions.assertFalse((boolean)ds.isBound());
        Assertions.assertTrue((boolean)ds.getLocalAddress().isAnyLocalAddress());
        Assertions.assertNull((Object)ds.getLocalSocketAddress());
        Assertions.assertEquals((int)0, (int)ds.getLocalPort());
    }

    private static void assertClosedDatagramSocket(AFUNIXDatagramSocket ds) {
        Assertions.assertTrue((boolean)ds.isClosed());
        Assertions.assertNull((Object)ds.getLocalAddress());
        Assertions.assertNull((Object)ds.getLocalSocketAddress());
        Assertions.assertEquals((int)-1, (int)ds.getLocalPort());
    }

    private static void assertBoundDatagramSocket(AFUNIXDatagramSocket ds, AFUNIXSocketAddress boundAddr) throws SocketException {
        Assertions.assertTrue((boolean)ds.isBound());
        Assertions.assertFalse((boolean)ds.isClosed());
        Assertions.assertEquals((int)0, (int)ds.getLocalPort());
        Assertions.assertFalse((boolean)ds.getLocalAddress().isAnyLocalAddress());
        Assertions.assertEquals((Object)boundAddr, (Object)AFUNIXSocketAddress.unwrap((InetAddress)ds.getLocalAddress(), (int)0));
        Assertions.assertEquals((Object)boundAddr, (Object)ds.getLocalSocketAddress());
    }

    private static void assertConnectedDatagramSocket(AFUNIXDatagramSocket ds, AFUNIXSocketAddress boundAddr, AFUNIXSocketAddress remoteAddr) throws SocketException {
        Assertions.assertTrue((boolean)ds.isConnected());
        Assertions.assertFalse((boolean)ds.isClosed());
        Assertions.assertEquals((Object)remoteAddr, (Object)ds.getRemoteSocketAddress());
        if (boundAddr != null) {
            AFUNIXDatagramSocketTest.assertBoundDatagramSocket(ds, boundAddr);
        } else {
            Assertions.assertEquals((int)0, (int)ds.getLocalPort());
        }
    }

    private static void assertDatagramPacketAddress(DatagramPacket dp, AFUNIXSocketAddress addr) {
        Assertions.assertEquals((Object)addr.wrapAddress(), (Object)dp.getAddress());
        Assertions.assertEquals((Object)new InetSocketAddress(addr.wrapAddress(), addr.getPort()), (Object)dp.getSocketAddress());
        Assertions.assertEquals((int)0, (int)dp.getPort());
    }

    @Test
    public void testBindConnect() throws SocketException, IOException, InterruptedException {
        AFUNIXSocketAddress ds1Addr = AFUNIXSocketAddress.of((File)SocketTestBase.newTempFile());
        AFUNIXSocketAddress ds2Addr = AFUNIXSocketAddress.of((File)SocketTestBase.newTempFile());
        Assertions.assertNotEquals((Object)ds1Addr, (Object)ds2Addr);
        try (AFUNIXDatagramSocket ds1 = AFUNIXDatagramSocket.newInstance();
             AFUNIXDatagramSocket ds2 = AFUNIXDatagramSocket.newInstance();){
            AFUNIXDatagramSocketTest.assertUnconnectedDatagramSocket(ds1);
            ds1.bind((SocketAddress)ds1Addr);
            Assertions.assertNull((Object)ds1.getRemoteSocketAddress());
            AFUNIXDatagramSocketTest.assertBoundDatagramSocket(ds1, ds1Addr);
            ds2.bind((SocketAddress)ds2Addr);
            ds1.connect((SocketAddress)ds2Addr);
            AFUNIXDatagramSocketTest.assertConnectedDatagramSocket(ds1, ds1Addr, ds2Addr);
            byte[] data = "Hello world!".getBytes(StandardCharsets.UTF_8);
            byte[] buf = new byte[512];
            System.arraycopy(data, 0, buf, 0, data.length);
            DatagramPacket dp1 = new DatagramPacket(buf, data.length);
            ds1.send(dp1);
            DatagramPacket dp2 = new DatagramPacket(new byte[1024], 3, 1021);
            dp2.setPort(123);
            ds2.receive(dp2);
            byte[] received = new byte[dp2.getLength()];
            System.arraycopy(dp2.getData(), dp2.getOffset(), received, 0, dp2.getLength());
            Assertions.assertArrayEquals((byte[])data, (byte[])received);
            AFUNIXDatagramSocketTest.assertDatagramPacketAddress(dp2, ds1Addr);
            dp2.setAddress(ds1Addr.wrapAddress());
            ds2.send(dp2);
            dp1.setLength(100);
            ds1.receive(dp1);
            Assertions.assertEquals((int)12, (int)dp1.getLength());
            Assertions.assertEquals((Object)ds2Addr.wrapAddress(), (Object)dp1.getAddress());
            ds1.close();
            AFUNIXDatagramSocketTest.assertClosedDatagramSocket(ds1);
            ds2.close();
            AFUNIXDatagramSocketTest.assertClosedDatagramSocket(ds2);
        }
    }

    @Test
    public void testPeek() throws Exception {
        AFUNIXSocketAddress ds2Addr = AFUNIXSocketAddress.of((File)SocketTestBase.newTempFile());
        try (AFUNIXDatagramSocket ds1 = AFUNIXDatagramSocket.newInstance();
             AFUNIXDatagramSocket ds2 = AFUNIXDatagramSocket.newInstance();){
            ds2.bind((SocketAddress)ds2Addr);
            DatagramPacket dp1 = AFUNIXDatagramUtil.datagramWithCapacityAndPayload((int)1024, (byte[])"Hello".getBytes(StandardCharsets.UTF_8));
            dp1.setAddress(ds2Addr.wrapAddress());
            ds1.send(dp1);
            DatagramPacket dp2 = AFUNIXDatagramUtil.datagramWithCapacity((int)1024);
            ds2.peek(dp2);
            Assertions.assertEquals((Object)"Hello", (Object)new String(dp2.getData(), dp2.getOffset(), dp2.getLength(), StandardCharsets.UTF_8));
            DatagramPacket dp3 = AFUNIXDatagramUtil.datagramWithCapacity((int)1024);
            ds2.receive(dp3);
            Assertions.assertEquals((Object)"Hello", (Object)new String(dp3.getData(), dp3.getOffset(), dp3.getLength(), StandardCharsets.UTF_8));
        }
    }

    @Test
    public void testReadTimeout() throws Exception {
        AFUNIXSocketAddress dsAddr = AFUNIXSocketAddress.of((File)SocketTestBase.newTempFile());
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
            try (AFUNIXDatagramSocket ds = AFUNIXDatagramSocket.newInstance();){
                ds.setSoTimeout(50);
                ds.bind((SocketAddress)dsAddr);
                Assertions.assertThrows(SocketTimeoutException.class, () -> ds.receive(AFUNIXDatagramUtil.datagramWithCapacity((int)64)));
            }
        });
    }

    @Test
    public void testPeekTimeout() throws Exception {
        AFUNIXSocketAddress dsAddr = AFUNIXSocketAddress.of((File)SocketTestBase.newTempFile());
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
            try (AFUNIXDatagramSocket ds = AFUNIXDatagramSocket.newInstance();){
                ds.setSoTimeout(50);
                ds.bind((SocketAddress)dsAddr);
                Assertions.assertThrows(SocketTimeoutException.class, () -> {
                    DatagramPacket dp = AFUNIXDatagramUtil.datagramWithCapacity((int)64);
                    ds.peek(dp);
                });
            }
        });
    }
}

