/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.server.ExportException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.rmi.AFUNIXNaming;
import org.newsclub.net.unix.rmi.AFUNIXRMIService;
import org.newsclub.net.unix.rmi.Hello;
import org.newsclub.net.unix.rmi.HelloImpl;
import org.newsclub.net.unix.rmi.ShutdownHookTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class RegistryTest
extends ShutdownHookTestBase {
    @Test
    public void testDoubleCreateRegistry() throws Exception {
        AFUNIXNaming naming = AFUNIXNaming.newPrivateInstance();
        naming.createRegistry();
        naming.createRegistry();
        naming.shutdownRegistry();
    }

    @Test
    public void testExportAndBind() throws Exception {
        AFUNIXNaming naming = AFUNIXNaming.newPrivateInstance();
        Assertions.assertEquals((Object)naming.getRegistrySocketDir(), (Object)naming.getSocketFactory().getSocketDir());
        naming.createRegistry();
        Assertions.assertEquals(Arrays.asList(AFUNIXRMIService.class.getName()), Arrays.asList(naming.list()));
        HelloImpl hello = new HelloImpl();
        Assertions.assertThrows(NotBoundException.class, () -> naming.lookup("hello", 1L, TimeUnit.MILLISECONDS));
        naming.exportAndBind("hello", (Remote)hello);
        Assertions.assertThrows(ExportException.class, () -> naming.exportAndBind("hello", (Remote)hello));
        naming.bind("hello2", (Remote)hello);
        naming.rebind("hello2", (Remote)hello);
        Assertions.assertThrows(AlreadyBoundException.class, () -> naming.bind("hello2", (Remote)hello));
        Assertions.assertEquals(new HashSet<String>(Arrays.asList(AFUNIXRMIService.class.getName(), "hello", "hello2")), new HashSet<String>(Arrays.asList(naming.list())));
        Assertions.assertEquals((Object)"Hello", (Object)((Hello)naming.lookup("hello2")).hello());
        Assertions.assertEquals((Object)"Hello", (Object)((Hello)naming.lookup("hello2", 1L, TimeUnit.MILLISECONDS)).hello());
        naming.exportAndRebind("hello2", (Remote)new HelloImpl());
        naming.unbind("hello2");
        naming.unexportAndUnbind("hello", (Remote)hello);
        Assertions.assertEquals(Arrays.asList(AFUNIXRMIService.class.getName()), Arrays.asList(naming.list()));
        naming.shutdownRegistry();
        Assertions.assertEquals(Arrays.asList(new Object[0]), Arrays.asList(naming.list()));
    }
}

