/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.testutil.AssertUtil;
import com.kohlschutter.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SoTimeoutTest
extends SocketTestBase {
    @Test
    public void issue14Fail() throws Exception {
        final Semaphore sema = new Semaphore(0);
        try (SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

            @Override
            protected void handleConnection(AFUNIXSocket socket) throws IOException {
                try {
                    socket.close();
                }
                finally {
                    sema.release();
                }
            }
        };
             AFUNIXSocket sock = this.connectToServer();){
            sema.acquire();
            try {
                sock.setSoTimeout((int)TimeUnit.SECONDS.toMillis(12L));
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    @Test
    public void issue14Pass() throws Exception {
        final Semaphore sema = new Semaphore(0);
        try (SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(){

            @Override
            protected void handleConnection(AFUNIXSocket sock) throws IOException {
                try (InputStream inputStream = sock.getInputStream();){
                    inputStream.read();
                    sema.acquire();
                }
                catch (IOException | InterruptedException exception) {
                    // empty catch block
                }
            }
        };
             AFUNIXSocket sock = this.connectToServer();){
            Assertions.assertTrue((boolean)sock.isConnected());
            Assertions.assertFalse((boolean)sock.isClosed());
            try {
                sock.setSoTimeout((int)TimeUnit.SECONDS.toMillis(12L));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw e;
            }
            finally {
                sema.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSocketTimeoutExceptionRead() throws Exception {
        File tempFile = SoTimeoutTest.newTempFile();
        AFUNIXSocketAddress address = AFUNIXSocketAddress.of((File)tempFile);
        try (AFUNIXServerSocket server = AFUNIXServerSocket.bindOn((AFUNIXSocketAddress)address);
             AFUNIXSocket client = AFUNIXSocket.connectTo((AFUNIXSocketAddress)address);){
            AFUNIXSocket socket = server.accept();
            socket.setSoTimeout(500);
            byte[] buf = new byte[socket.getReceiveBufferSize()];
            InputStream in = socket.getInputStream();
            Assertions.assertThrows(SocketTimeoutException.class, () -> AssertUtil.ignoreValue((Object)in.read(buf)));
        }
        finally {
            IOUtil.delete((File)tempFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSocketTimeoutExceptionWrite() throws Exception {
        File tempFile = SoTimeoutTest.newTempFile();
        AFUNIXSocketAddress address = AFUNIXSocketAddress.of((File)tempFile);
        try (AFUNIXServerSocket server = AFUNIXServerSocket.bindOn((AFUNIXSocketAddress)address);
             AFUNIXSocket client = AFUNIXSocket.connectTo((AFUNIXSocketAddress)address);){
            AFUNIXSocket socket = server.accept();
            socket.setSoTimeout(500);
            byte[] buf = new byte[socket.getSendBufferSize()];
            OutputStream out = socket.getOutputStream();
            try {
                out.write(buf);
                out.write(buf);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                // empty catch block
            }
        }
        finally {
            IOUtil.delete((File)tempFile);
        }
    }
}

