/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketCapability;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AFUNIXSocketTest {
    @Test
    public void testMain() throws Exception {
        AFUNIXSocket.main((String[])new String[0]);
    }

    @Test
    public void testVersion() throws Exception {
        Assertions.assertNotEquals((Object)"", (Object)AFUNIXSocket.getVersion());
    }

    @Test
    public void testSupported() throws Exception {
        Assertions.assertTrue((boolean)AFUNIXSocket.isSupported());
    }

    @Test
    public void testLoadedLibrary() throws Exception {
        Assertions.assertNotEquals((Object)"", (Object)AFUNIXSocket.getLoadedLibrary());
    }

    @Test
    public void testCloseable() throws Exception {
        final AtomicBoolean closed = new AtomicBoolean(false);
        Closeable closeable = new Closeable(){

            @Override
            public void close() throws IOException {
                closed.set(true);
            }
        };
        try (AFUNIXSocket socket = AFUNIXSocket.newInstance();){
            socket.addCloseable(null);
            socket.addCloseable(closeable);
            socket.removeCloseable(null);
            socket.removeCloseable(closeable);
        }
        Assertions.assertFalse((boolean)closed.get());
        socket = AFUNIXSocket.newInstance();
        try {
            socket.addCloseable(closeable);
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
        Assertions.assertTrue((boolean)closed.get());
    }

    @Test
    public void testSupports() throws Exception {
        for (AFUNIXSocketCapability cap : AFUNIXSocketCapability.values()) {
            AFUNIXSocket.supports((AFUNIXSocketCapability)cap);
        }
    }

    @Test
    public void testConnectBadArguments() throws Exception {
        try (AFUNIXSocket socket = AFUNIXSocket.newInstance();){
            Assertions.assertThrows(IllegalArgumentException.class, () -> socket.connect(null));
            Assertions.assertThrows(IllegalArgumentException.class, () -> socket.connect((SocketAddress)new InetSocketAddress(0), -1));
            Assertions.assertThrows(IllegalArgumentException.class, () -> socket.connect((SocketAddress)new InetSocketAddress(0), 0));
            Assertions.assertEquals((Object)"[invalid]", (Object)socket.toString().replaceFirst("^.*?\\[", "["));
        }
        socket = AFUNIXSocket.newInstance();
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> socket.connect((SocketAddress)null));
            Assertions.assertThrows(IllegalArgumentException.class, () -> socket.connect((SocketAddress)new InetSocketAddress("http://example.com/", 0)));
            Assertions.assertThrows(IllegalArgumentException.class, () -> socket.connect((SocketAddress)new InetSocketAddress("", 0), -1));
            Assertions.assertThrows(IllegalArgumentException.class, () -> socket.connect((SocketAddress)new InetSocketAddress("file://", 0)));
            Assertions.assertThrows(IllegalArgumentException.class, () -> socket.connect((SocketAddress)new InetSocketAddress("file://not-absolute", 0)));
            Assertions.assertThrows(IllegalArgumentException.class, () -> socket.connect((SocketAddress)new InetSocketAddress("file:///", 0)));
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    @Test
    public void testBindBadArguments() throws Exception {
        try (AFUNIXSocket sock = AFUNIXSocket.newInstance();){
            Assertions.assertFalse((boolean)sock.isBound());
            Assertions.assertThrows(IllegalArgumentException.class, () -> sock.bind(null));
            Assertions.assertFalse((boolean)sock.isBound());
        }
        sock = AFUNIXSocket.newInstance();
        try {
            Assertions.assertFalse((boolean)sock.isBound());
            Assertions.assertThrows(IllegalArgumentException.class, () -> sock.bind((SocketAddress)new InetSocketAddress("", 0)));
            Assertions.assertFalse((boolean)sock.isBound());
        }
        finally {
            if (sock != null) {
                sock.close();
            }
        }
    }

    @Test
    public void testReceivedFileDescriptorsUnconnected() throws Exception {
        try (AFUNIXSocket sock = AFUNIXSocket.newInstance();){
            Assertions.assertNull((Object)sock.getReceivedFileDescriptors());
            sock.clearReceivedFileDescriptors();
        }
    }

    @Test
    public void testUnconnectedSocket() throws IOException {
        try (AFUNIXSocket socket = AFUNIXSocket.newInstance();){
            Assertions.assertTrue((socket.getReceiveBufferSize() > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((socket.getSendBufferSize() > 0 ? 1 : 0) != 0);
        }
    }
}

