/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelector;
import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFUNIXSelectorProvider;
import org.newsclub.net.unix.AFUNIXServerSocketChannel;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketChannel;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AFUNIXSelectorTest {
    private final AFUNIXSelectorProvider provider = AFUNIXSelectorProvider.provider();

    private static void assertChangeToNonBlocking(AFUNIXServerSocketChannel as) throws IOException {
        Assertions.assertTrue((boolean)as.isBlocking());
        as.configureBlocking(false);
        Assertions.assertFalse((boolean)as.isBlocking());
    }

    private static void assertSelect(int expected, Selector sel, boolean block) throws IOException {
        Assertions.assertEquals((int)expected, (int)sel.selectNow());
        if (block) {
            Assertions.assertEquals((int)expected, (int)sel.select(1L));
            Assertions.assertEquals((int)expected, (int)sel.select());
        }
        Assertions.assertEquals((int)expected, (int)sel.selectNow());
        Assertions.assertEquals((int)expected, (int)sel.selectedKeys().size());
    }

    @Test
    public void testNonBlockingAccept() throws IOException, InterruptedException {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
            AFUNIXSocketAddress sa = AFUNIXSocketAddress.of((File)SocketTestBase.newTempFile());
            AbstractSelector sscSel = this.provider.openSelector();
            Assertions.assertTrue((boolean)sscSel.selectedKeys().isEmpty());
            try (AFUNIXServerSocketChannel ssc = this.provider.openServerSocketChannel((SocketAddress)sa);){
                AFUNIXSelectorTest.assertChangeToNonBlocking(ssc);
                SelectionKey key = ssc.register((Selector)sscSel, 16);
                Assertions.assertEquals(Collections.singleton(key), sscSel.keys());
                Assertions.assertTrue((boolean)sscSel.selectedKeys().isEmpty());
                Assertions.assertNull((Object)ssc.accept());
                Assertions.assertEquals((int)0, (int)sscSel.selectNow());
                try (AFUNIXSocketChannel sc = this.provider.openSocketChannel((SocketAddress)sa);){
                    AFUNIXSelectorTest.assertSelect(1, sscSel, true);
                    Assertions.assertEquals(Collections.singleton(key), sscSel.selectedKeys());
                    AFUNIXSocketChannel sscsc = ssc.accept();
                    Assertions.assertNotNull((Object)sscsc);
                    Assertions.assertNull((Object)ssc.accept());
                }
            }
            AFUNIXSelectorTest.assertSelect(0, sscSel, false);
        });
    }

    @Test
    public void testCancelSelect() throws Exception {
        final AbstractSelector selector = this.provider.openSelector();
        final CompletableFuture cf = new CompletableFuture();
        new Thread(){

            @Override
            public void run() {
                int num;
                try {
                    num = selector.select();
                }
                catch (IOException e) {
                    cf.completeExceptionally(e);
                    return;
                }
                cf.complete(num);
            }
        }.start();
        selector.wakeup();
        Assertions.assertEquals((int)0, (Integer)((Integer)cf.get(5L, TimeUnit.SECONDS)));
    }
}

