/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.lang.reflect.InvocationTargetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class TestUtils {
    private static final Pattern PAT_PID_IN_MX_BEAN_NAME = Pattern.compile("^([0-9]+)\\@");

    private TestUtils() {
        throw new IllegalStateException("No instances");
    }

    public static long getPid() {
        Class<?> phClass = null;
        try {
            phClass = Class.forName("java.lang.ProcessHandle");
        }
        catch (ClassNotFoundException e) {
            return TestUtils.getPidFallback();
        }
        try {
            Object currentProcessHandle = phClass.getMethod("current", new Class[0]).invoke(null, new Object[0]);
            return (Long)phClass.getMethod("pid", new Class[0]).invoke(currentProcessHandle, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to determine current process PID", e);
        }
    }

    private static long getPidFallback() {
        Class<?> mxBeanClass;
        Class<?> managementClass;
        try {
            managementClass = Class.forName("java.lang.management.ManagementFactory");
            mxBeanClass = Class.forName("java.lang.management.RuntimeMXBean");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to determine current process PID", e);
        }
        try {
            Object mxBean = managementClass.getMethod("getRuntimeMXBean", new Class[0]).invoke(null, new Object[0]);
            String name = mxBeanClass.getMethod("getName", new Class[0]).invoke(mxBean, new Object[0]).toString();
            Matcher m = PAT_PID_IN_MX_BEAN_NAME.matcher(name);
            if (m.find()) {
                long pid = Long.parseLong(m.group(1));
                return pid;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to determine current process PID", e);
        }
        throw new IllegalStateException("Unable to determine current process PID");
    }
}

