/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketCapability;
import org.newsclub.net.unix.AFUNIXSocketCapabilityRequirement;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AFUNIXSocketCapabilityCondition
implements ExecutionCondition {
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        AFUNIXSocketCapabilityRequirement requirement;
        Object[] requiredCapabilities = new AFUNIXSocketCapability[]{};
        Optional element = context.getElement();
        if (element.isPresent() && (requirement = ((AnnotatedElement)element.get()).getAnnotation(AFUNIXSocketCapabilityRequirement.class)) != null) {
            requiredCapabilities = requirement.value();
        }
        ArrayList<AFUNIXSocketCapability> unsupported = new ArrayList<AFUNIXSocketCapability>(requiredCapabilities.length);
        for (AFUNIXSocketCapability aFUNIXSocketCapability : requiredCapabilities) {
            if (AFUNIXSocket.supports((AFUNIXSocketCapability)aFUNIXSocketCapability)) continue;
            unsupported.add(aFUNIXSocketCapability);
        }
        ConditionEvaluationResult result = unsupported.isEmpty() ? ConditionEvaluationResult.enabled((String)("AFUNIXSocket environment supports all required capabilities: " + Arrays.toString(requiredCapabilities))) : ConditionEvaluationResult.disabled((String)("AFUNIXSocket environment does not support the following capabilities: " + unsupported));
        return result;
    }
}

