/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.selftest.apps;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import org.newsclub.net.unix.AFAddressFamily;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.selftest.apps.IOUtil;
import org.newsclub.net.unix.selftest.apps.SocketAddressUtil;
import org.newsclub.net.unix.server.AFSocketServer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class EchoServer {
    private static void printHelp() {
        System.err.println("Syntax: java " + EchoServer.class.getName() + " <URI>");
        System.err.println();
        System.err.println("Supported schemes: " + AFAddressFamily.uriSchemes());
    }

    public static void main(String[] args) throws IOException, InterruptedException, ExecutionException {
        AFSocketAddress address;
        if (args.length == 0) {
            EchoServer.printHelp();
            System.exit(1);
            return;
        }
        try {
            address = SocketAddressUtil.parseAddress(args[0]);
        }
        catch (Exception e) {
            EchoServer.printHelp();
            System.err.println();
            e.printStackTrace();
            System.exit(1);
            return;
        }
        new AFSocketServer<AFSocketAddress>(address){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void doServeSocket(AFSocket<?> sock) throws IOException {
                System.out.println("Connected: " + sock);
                long numBytes = -1L;
                long time = System.currentTimeMillis();
                try {
                    numBytes = IOUtil.transfer((InputStream)sock.getInputStream(), (OutputStream)sock.getOutputStream());
                }
                catch (Throwable throwable) {
                    time = System.currentTimeMillis() - time;
                    System.out.println("Disconnected: " + sock + "; echoed bytes: " + (numBytes == -1L ? "unknown" : Long.valueOf(numBytes)) + "; speed: " + (numBytes == -1L || time == 0L ? "unknown" : numBytes * 1000L / time + "/s"));
                    throw throwable;
                }
                time = System.currentTimeMillis() - time;
                System.out.println("Disconnected: " + sock + "; echoed bytes: " + (numBytes == -1L ? "unknown" : Long.valueOf(numBytes)) + "; speed: " + (numBytes == -1L || time == 0L ? "unknown" : numBytes * 1000L / time + "/s"));
            }
        }.startAndWaitToBecomeReady();
        System.out.println("Server ready, listening on " + address);
    }
}

