/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.jep380;

import com.kohlschutter.testutil.TestAbortedNotAnIssueException;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ProtocolFamily;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.StandardProtocolFamily;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Pipe;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.nio.file.Path;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.CloseablePair;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JEP380AddressSpecifics
implements AddressSpecifics<SocketAddress> {
    public static final AddressSpecifics<SocketAddress> INSTANCE = new JEP380AddressSpecifics();
    private final ProtocolFamily pf = JEP380AddressSpecifics.unixProtocolFamilyIfAvailable();
    private final Method addressOfMethod = JEP380AddressSpecifics.tryResolve("java.net.UnixDomainSocketAddress", "of", Path.class);
    private final Method socketChannelOpenMethod = JEP380AddressSpecifics.tryResolve("java.nio.channels.SocketChannel", "open", ProtocolFamily.class);
    private final Method serverSocketChannelOpenMethod = JEP380AddressSpecifics.tryResolve("java.nio.channels.ServerSocketChannel", "open", ProtocolFamily.class);
    private final Method datagramChannelOpenMethod = JEP380AddressSpecifics.tryResolve("java.nio.channels.DatagramChannel", "open", ProtocolFamily.class);
    private final SelectorProvider sp = new SelectorProvider(){
        private final SelectorProvider upstream = SelectorProvider.provider();

        @Override
        public SocketChannel openSocketChannel() throws IOException {
            return JEP380AddressSpecifics.this.newSocketChannel();
        }

        @Override
        public ServerSocketChannel openServerSocketChannel() throws IOException {
            return JEP380AddressSpecifics.this.newServerSocketChannel();
        }

        @Override
        public AbstractSelector openSelector() throws IOException {
            return this.upstream.openSelector();
        }

        @Override
        public Pipe openPipe() throws IOException {
            return this.upstream.openPipe();
        }

        @Override
        public DatagramChannel openDatagramChannel(ProtocolFamily family) throws IOException {
            return this.upstream.openDatagramChannel(family);
        }

        @Override
        public DatagramChannel openDatagramChannel() throws IOException {
            return JEP380AddressSpecifics.this.newDatagramChannel();
        }
    };

    private JEP380AddressSpecifics() {
    }

    private static Method tryResolve(String className, String methodName, Class<?> ... argType) {
        try {
            Class<?> udsa = Class.forName(className);
            return udsa.getMethod(methodName, argType);
        }
        catch (Exception e) {
            return null;
        }
    }

    private ProtocolFamily unixProtocolFamily() {
        if (this.pf == null) {
            throw new UnsupportedOperationException("StandardProtocolFamily.UNIX is unavailable");
        }
        return this.pf;
    }

    public static ProtocolFamily unixProtocolFamilyIfAvailable() {
        for (StandardProtocolFamily pf : StandardProtocolFamily.values()) {
            if (!"UNIX".equals(pf.name())) continue;
            return pf;
        }
        return null;
    }

    private SocketAddress addressOfPath(Path p) {
        if (this.addressOfMethod == null) {
            throw new UnsupportedOperationException("UnixDomainSocketAddress.of is unavailable");
        }
        try {
            return (SocketAddress)this.addressOfMethod.invoke(null, p);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("UnixDomainSocketAddress.of is unavailable", e);
        }
    }

    public SocketAddress wildcardBindAddress() throws IOException {
        AFUNIXSocketAddress tmpAddr = AFUNIXSocketAddress.ofNewTempFile();
        return this.addressOfPath(tmpAddr.getFile().toPath());
    }

    @Override
    public SocketAddress newTempAddress() throws IOException {
        return this.wildcardBindAddress();
    }

    @Override
    public Socket newStrictSocket() throws IOException {
        return this.newSocket();
    }

    @Override
    public Socket newSocket() throws IOException {
        throw new TestAbortedNotAnIssueException("unsupported by Java SDK Unix Domain sockets");
    }

    @Override
    public DatagramSocket newDatagramSocket() throws IOException {
        throw new TestAbortedNotAnIssueException("unsupported by Java SDK Unix Domain sockets");
    }

    @Override
    public ServerSocket newServerSocket() throws IOException {
        throw new TestAbortedNotAnIssueException("unsupported by Java SDK Unix Domain sockets");
    }

    @Override
    public SocketAddress newTempAddressForDatagram() throws IOException {
        return this.newTempAddress();
    }

    @Override
    public SocketAddress unwrap(InetAddress addr, int port) throws SocketException {
        throw new TestAbortedNotAnIssueException("unsupported by Java SDK Unix Domain sockets");
    }

    @Override
    public SelectorProvider selectorProvider() {
        return this.sp;
    }

    @Override
    public CloseablePair<? extends SocketChannel> newSocketPair() throws IOException {
        CloseablePair<Socket> p1 = this.newInterconnectedSockets();
        return new CloseablePair((Closeable)((Socket)p1.getFirst()).getChannel(), (Closeable)((Socket)p1.getSecond()).getChannel(), p1);
    }

    @Override
    public CloseablePair<? extends DatagramChannel> newDatagramSocketPair() throws IOException {
        DatagramChannel ds1 = this.newDatagramChannel();
        ds1.bind(this.newTempAddress());
        DatagramChannel ds2 = this.newDatagramChannel();
        ds2.bind(this.newTempAddress());
        ds1.connect(ds2.getLocalAddress());
        ds2.connect(ds1.getLocalAddress());
        return new CloseablePair((Closeable)ds1, (Closeable)ds2, () -> {
            ds1.close();
            ds2.close();
        });
    }

    @Override
    public ServerSocket newServerSocketBindOn(SocketAddress addr) throws IOException {
        throw new TestAbortedNotAnIssueException("unsupported by Java SDK Unix Domain sockets");
    }

    @Override
    public Socket connectTo(SocketAddress addr) throws IOException {
        throw new TestAbortedNotAnIssueException("unsupported by Java SDK Unix Domain sockets");
    }

    @Override
    public ServerSocket newServerSocketBindOn(SocketAddress addr, boolean deleteOnClose) throws IOException {
        throw new TestAbortedNotAnIssueException("unsupported by Java SDK Unix Domain sockets");
    }

    @Override
    public String addressFamilyString() {
        return "Java UNIX domain socket";
    }

    @Override
    public String summaryImportantMessage(String message) {
        return message;
    }

    @Override
    public SocketChannel newSocketChannel() throws IOException {
        try {
            return (SocketChannel)this.socketChannelOpenMethod.invoke(null, this.unixProtocolFamily());
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public DatagramChannel newDatagramChannel() throws IOException {
        try {
            return (DatagramChannel)this.datagramChannelOpenMethod.invoke(null, this.unixProtocolFamily());
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public ServerSocketChannel newServerSocketChannel() throws IOException {
        try {
            return (ServerSocketChannel)this.serverSocketChannelOpenMethod.invoke(null, this.unixProtocolFamily());
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }
}

