/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.domain;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.charset.Charset;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.SocketTestBase;
import org.newsclub.net.unix.domain.AFUNIXAddressSpecifics;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
public final class SocketAddressTest
extends SocketTestBase<AFUNIXSocketAddress> {
    public SocketAddressTest() {
        super(AFUNIXAddressSpecifics.INSTANCE);
    }

    @Test
    public void testPort() throws IOException {
        Assertions.assertEquals((int)0, (int)AFUNIXSocketAddress.of((File)new File("/tmp/whatever")).getPort());
        Assertions.assertEquals((int)123, (int)AFUNIXSocketAddress.of((File)new File("/tmp/whatever"), (int)123).getPort());
        try {
            AFUNIXSocketAddress.of((File)new File("/tmp/whatever"), (int)-2);
            Assertions.fail((String)"Expected IllegalArgumentException for illegal port");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assertions.assertEquals((int)44444, (int)AFUNIXSocketAddress.of((File)new File("/tmp/whatever"), (int)44444).getPort());
        AFUNIXSocketAddress.of((File)new File("/tmp/whatever"), (int)65535);
    }

    @Test
    public void testLargePort() throws Exception {
        boolean supportsLargePorts = AFSocket.supports((AFSocketCapability)AFSocketCapability.CAPABILITY_LARGE_PORTS);
        try {
            Assertions.assertEquals((int)544444, (int)AFUNIXSocketAddress.of((File)new File("/tmp/whatever"), (int)544444).getPort());
        }
        catch (SocketException e) {
            Assertions.assertFalse((boolean)supportsLargePorts);
        }
        try {
            AFUNIXSocketAddress.of((File)new File("/tmp/whatever"), (int)65536);
        }
        catch (SocketException e) {
            Assertions.assertFalse((boolean)supportsLargePorts);
        }
    }

    @Test
    public void testPath() throws Exception {
        Assertions.assertEquals((Object)"/tmp/whatever", (Object)AFUNIXSocketAddress.of((File)new File("/tmp/whatever")).getPath().replace(File.separatorChar, '/'));
        Assertions.assertEquals((Object)"whatever", (Object)AFUNIXSocketAddress.of((File)new File("whatever")).getPath().replace(File.separatorChar, '/'));
        byte[] bytes = AFUNIXSocketAddress.of((File)new File("/tmp/whatever")).getPathAsBytes();
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != (byte)File.separatorChar) continue;
            bytes[i] = 47;
        }
        Assertions.assertArrayEquals((byte[])"/tmp/whatever".getBytes(Charset.defaultCharset()), (byte[])bytes);
    }

    @Test
    public void testAbstractNamespace() throws Exception {
        AFUNIXSocketAddress address = AFUNIXSocketAddress.inAbstractNamespace((String)"test\n\u000b\u0000\u007f");
        if (!"z/OS".equals(System.getProperty("os.name"))) {
            byte[] addressBytes = new byte[]{0, 116, 101, 115, 116, 10, 11, 0, 127};
            Assertions.assertArrayEquals((byte[])addressBytes, (byte[])address.getPathAsBytes());
        }
        Assertions.assertEquals((int)0, (int)address.getPort());
        if (!"z/OS".equals(System.getProperty("os.name"))) {
            Assertions.assertEquals((Object)"@test..@.", (Object)address.getPath());
            Assertions.assertEquals((Object)"[path=\\x00test\\x0a\\x0b\\x00\\x7f]", (Object)address.toString().replaceFirst("^.*?\\[", "["));
        }
        Assertions.assertTrue((boolean)address.isInAbstractNamespace());
        Assertions.assertFalse((boolean)address.hasFilename());
        Assertions.assertThrows(FileNotFoundException.class, () -> ((AFUNIXSocketAddress)address).getFile());
    }

    @Test
    public void testEmptyAddress() throws Exception {
        Assertions.assertThrows(SocketException.class, () -> AFUNIXSocketAddress.of((byte[])new byte[0]));
    }

    @Test
    public void testByteConstructor() throws Exception {
        Assertions.assertEquals((Object)"@", (Object)AFUNIXSocketAddress.of((byte[])new byte[]{0}).getPath());
        Assertions.assertEquals((Object)"@..", (Object)AFUNIXSocketAddress.of((byte[])new byte[]{0, -128, -1}).getPath());
        Assertions.assertEquals((Object)"abc.123", (Object)AFUNIXSocketAddress.of((byte[])"abc.123".getBytes(AFUNIXSocketAddress.addressCharset())).getPath());
        Assertions.assertEquals((Object)new File("abc.123"), (Object)AFUNIXSocketAddress.of((File)new File("abc.123")).getFile());
        Assertions.assertEquals((Object)"abc.123", (Object)AFUNIXSocketAddress.of((File)new File("abc.123")).getPath());
    }

    @Test
    public void testInetAddress() throws Exception {
        AFUNIXSocketAddress addr1 = AFUNIXSocketAddress.of((File)new File("/tmp/testing"));
        Assertions.assertTrue((boolean)AFUNIXSocketAddress.isSupportedAddress((SocketAddress)addr1));
        Assertions.assertNull((Object)addr1.getAddress());
        Assertions.assertTrue((boolean)AFUNIXSocketAddress.isSupportedAddress((InetAddress)addr1.wrapAddress()));
        AFUNIXSocketAddress addr2 = AFUNIXSocketAddress.unwrap((InetAddress)addr1.wrapAddress(), (int)0);
        Assertions.assertEquals((Object)addr1, (Object)addr2);
        Assertions.assertTrue((boolean)AFUNIXSocketAddress.isSupportedAddress((SocketAddress)addr2));
        Assertions.assertTrue((boolean)AFUNIXSocketAddress.isSupportedAddress((InetAddress)addr2.wrapAddress()));
        Assertions.assertNull((Object)addr2.getAddress());
    }

    @Test
    public void testLegacyConstructor() throws Exception {
        Assertions.assertEquals((Object)AFUNIXSocketAddress.of((File)new File("/tmp/socket")), (Object)new AFUNIXSocketAddress(new File("/tmp/socket")));
        Assertions.assertEquals((Object)AFUNIXSocketAddress.of((File)new File("/tmp/socket")), (Object)new AFUNIXSocketAddress(new File("/tmp/socket"), 0));
        Assertions.assertEquals((Object)AFUNIXSocketAddress.of((File)new File("/tmp/socket"), (int)1234), (Object)new AFUNIXSocketAddress(new File("/tmp/socket"), 1234));
    }
}

