/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.domain;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.util.IOUtil;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFDatagramUtil;
import org.newsclub.net.unix.AFInputStream;
import org.newsclub.net.unix.AFOutputStream;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketCapabilityRequirement;
import org.newsclub.net.unix.AFUNIXDatagramSocket;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketChannel;
import org.newsclub.net.unix.ImplUtil;
import org.newsclub.net.unix.SocketTestBase;
import org.newsclub.net.unix.domain.AFUNIXAddressSpecifics;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNIX_DOMAIN, AFSocketCapability.CAPABILITY_FILE_DESCRIPTORS})
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
public final class FileDescriptorsTest
extends SocketTestBase<AFUNIXSocketAddress> {
    public FileDescriptorsTest() {
        super(AFUNIXAddressSpecifics.INSTANCE);
    }

    @Test
    public void testSendRecvFileDescriptors() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            try (SocketTestBase.AFUNIXServerThread serverThread = new SocketTestBase.AFUNIXServerThread(){

                @Override
                protected void handleConnection(AFUNIXSocket socket) throws IOException {
                    socket.setOutboundFileDescriptors(new FileDescriptor[]{FileDescriptor.in, FileDescriptor.err});
                    Assertions.assertTrue((boolean)socket.hasOutboundFileDescriptors());
                    try (AFOutputStream outputStream = socket.getOutputStream();){
                        outputStream.write("HELLO".getBytes(StandardCharsets.UTF_8));
                    }
                    Assertions.assertFalse((boolean)socket.hasOutboundFileDescriptors());
                    this.stopAcceptingConnections();
                }
            };
                 AFUNIXSocket socket = (AFUNIXSocket)this.connectTo(serverThread.getServerAddress());
                 AFInputStream in = socket.getInputStream();){
                socket.setAncillaryReceiveBufferSize(1024);
                byte[] buf = new byte[64];
                Object[] fds = socket.getReceivedFileDescriptors();
                Assertions.assertArrayEquals((Object[])new FileDescriptor[0], (Object[])fds, (String)"Initially, there are no file descriptors");
                int numRead = in.read(buf);
                Assertions.assertEquals((int)5, (int)numRead, (String)"'HELLO' is five bytes long");
                Assertions.assertEquals((Object)"HELLO", (Object)new String(buf, 0, numRead, StandardCharsets.UTF_8));
                fds = socket.getReceivedFileDescriptors();
                Assertions.assertEquals((int)2, (int)fds.length, (String)"Now, we should have two file descriptors");
                fds = socket.getReceivedFileDescriptors();
                Assertions.assertArrayEquals((Object[])new FileDescriptor[0], (Object[])fds, (String)"If we ask again, these new file descriptors should be gone");
                try (AFInputStream is = socket.getInputStream();){
                    numRead = is.read(buf);
                    Assertions.assertEquals((int)-1, (int)numRead, (String)"There shouldn't be anything left to read");
                    fds = socket.getReceivedFileDescriptors();
                    Assertions.assertArrayEquals((Object[])new FileDescriptor[0], (Object[])fds, (String)"There shouldn't be any new file descriptors");
                }
            }
        });
    }

    @Test
    public void testSendRecvFileDescriptorsChannel() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            try (SocketTestBase.AFUNIXServerThread serverThread = new SocketTestBase.AFUNIXServerThread(){

                @Override
                protected void handleConnection(AFUNIXSocket socket) throws IOException {
                    AFUNIXSocketChannel channel = socket.getChannel();
                    channel.setOutboundFileDescriptors(new FileDescriptor[]{FileDescriptor.in, FileDescriptor.err});
                    Assertions.assertTrue((boolean)socket.hasOutboundFileDescriptors());
                    ByteBuffer bb = ByteBuffer.allocate(64);
                    bb.put("HELLO".getBytes(StandardCharsets.UTF_8));
                    bb.flip();
                    channel.write(bb);
                    Assertions.assertFalse((boolean)socket.hasOutboundFileDescriptors());
                    this.stopAcceptingConnections();
                }
            };
                 AFUNIXSocketChannel channel = ((AFUNIXSocket)this.connectTo(serverThread.getServerAddress())).getChannel();){
                channel.setAncillaryReceiveBufferSize(1024);
                Object[] fds = channel.getReceivedFileDescriptors();
                Assertions.assertArrayEquals((Object[])new FileDescriptor[0], (Object[])fds, (String)"Initially, there are no file descriptors");
                ByteBuffer buf = ByteBuffer.allocate(64);
                int numRead = channel.read(buf);
                Assertions.assertEquals((int)5, (int)numRead, (String)"'HELLO' is five bytes long");
                Assertions.assertEquals((Object)"HELLO", (Object)new String(buf.flip().array(), 0, numRead, StandardCharsets.UTF_8));
                fds = channel.getReceivedFileDescriptors();
                Assertions.assertEquals((int)2, (int)fds.length, (String)"Now, we should have two file descriptors");
                fds = channel.getReceivedFileDescriptors();
                Assertions.assertArrayEquals((Object[])new FileDescriptor[0], (Object[])fds, (String)"If we ask again, these new file descriptors should be gone");
                buf.clear();
                numRead = channel.read(buf);
                Assertions.assertEquals((int)-1, (int)numRead, (String)"There shouldn't be anything left to read");
                fds = channel.getReceivedFileDescriptors();
                Assertions.assertArrayEquals((Object[])new FileDescriptor[0], (Object[])fds, (String)"There shouldn't be any new file descriptors");
            }
        });
    }

    @Test
    public void testSendRecvFileDescriptorsChannelNonBlocking() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            try (SocketTestBase.AFUNIXServerThread serverThread = new SocketTestBase.AFUNIXServerThread(){

                @Override
                protected void handleConnection(AFUNIXSocket socket) throws IOException {
                    AFUNIXSocketChannel channel = socket.getChannel();
                    channel.configureBlocking(false);
                    channel.setOutboundFileDescriptors(new FileDescriptor[]{FileDescriptor.in, FileDescriptor.err});
                    Assertions.assertTrue((boolean)socket.hasOutboundFileDescriptors());
                    ByteBuffer bb = ByteBuffer.allocate(64);
                    bb.put("HELLO".getBytes(StandardCharsets.UTF_8));
                    bb.flip();
                    channel.write(bb);
                    Assertions.assertFalse((boolean)socket.hasOutboundFileDescriptors());
                    this.stopAcceptingConnections();
                }
            };
                 AFUNIXSocketChannel channel = ((AFUNIXSocket)this.connectTo(serverThread.getServerAddress())).getChannel();){
                int numRead;
                channel.configureBlocking(false);
                channel.setAncillaryReceiveBufferSize(1024);
                Object[] fds = channel.getReceivedFileDescriptors();
                Assertions.assertArrayEquals((Object[])new FileDescriptor[0], (Object[])fds, (String)"Initially, there are no file descriptors");
                ByteBuffer buf = ByteBuffer.allocate(64);
                while ((numRead = channel.read(buf)) >= 0 && buf.position() < 5) {
                }
                Assertions.assertEquals((int)5, (int)buf.position(), (String)"'HELLO' is five bytes long");
                Assertions.assertEquals((Object)"HELLO", (Object)new String(buf.flip().array(), 0, numRead, StandardCharsets.UTF_8));
                fds = channel.getReceivedFileDescriptors();
                Assertions.assertEquals((int)2, (int)fds.length, (String)"Now, we should have two file descriptors");
                fds = channel.getReceivedFileDescriptors();
                Assertions.assertArrayEquals((Object[])new FileDescriptor[0], (Object[])fds, (String)"If we ask again, these new file descriptors should be gone");
                buf.clear();
                numRead = channel.read(buf);
                if (numRead != 0) {
                    Assertions.assertEquals((int)-1, (int)numRead, (String)"There shouldn't be anything left to read");
                }
                fds = channel.getReceivedFileDescriptors();
                Assertions.assertArrayEquals((Object[])new FileDescriptor[0], (Object[])fds, (String)"There shouldn't be any new file descriptors");
            }
        });
    }

    @Test
    public void testNullFileDescriptorArray() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            try (SocketTestBase.AFUNIXServerThread serverThread = new SocketTestBase.AFUNIXServerThread(){

                @Override
                protected void handleConnection(AFUNIXSocket socket) throws IOException {
                    socket.setOutboundFileDescriptors((FileDescriptor[])null);
                    try (AFOutputStream outputStream = socket.getOutputStream();){
                        outputStream.write(123);
                    }
                    this.stopAcceptingConnections();
                }
            };
                 AFUNIXSocket socket = (AFUNIXSocket)this.connectTo(serverThread.getServerAddress());){
                socket.setAncillaryReceiveBufferSize(1024);
                try (AFInputStream inputStream = socket.getInputStream();){
                    inputStream.read();
                }
            }
        });
    }

    @Test
    public void testEmptyFileDescriptorArray() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            try (SocketTestBase.AFUNIXServerThread serverThread = new SocketTestBase.AFUNIXServerThread(){

                @Override
                protected void handleConnection(AFUNIXSocket socket) throws IOException {
                    socket.setOutboundFileDescriptors(new FileDescriptor[0]);
                    try (AFOutputStream outputStream = socket.getOutputStream();){
                        outputStream.write(123);
                    }
                    this.stopAcceptingConnections();
                }
            };
                 AFUNIXSocket socket = (AFUNIXSocket)this.connectTo(serverThread.getServerAddress());){
                socket.setAncillaryReceiveBufferSize(1024);
                try (AFInputStream inputStream = socket.getInputStream();){
                    inputStream.read();
                }
            }
        });
    }

    @Test
    public void testBadFileDescriptor() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            try (SocketTestBase.AFUNIXServerThread serverThread = new SocketTestBase.AFUNIXServerThread(){

                @Override
                protected void handleConnection(AFUNIXSocket socket) throws IOException {
                    socket.setOutboundFileDescriptors(new FileDescriptor[]{new FileDescriptor()});
                    try {
                        try (AFOutputStream outputStream = socket.getOutputStream();){
                            outputStream.write(123);
                        }
                        Assertions.fail((String)"Expected a \"Bad file descriptor\" SocketException");
                    }
                    catch (SocketException socketException) {
                        // empty catch block
                    }
                    this.stopAcceptingConnections();
                }
            };
                 AFUNIXSocket socket = (AFUNIXSocket)this.connectTo(serverThread.getServerAddress());){
                socket.setAncillaryReceiveBufferSize(1024);
                try (AFInputStream inputStream = socket.getInputStream();){
                    inputStream.read();
                }
            }
        });
    }

    @Test
    public void testNoAncillaryReceiveBuffer() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            try (SocketTestBase.AFUNIXServerThread serverThread = new SocketTestBase.AFUNIXServerThread(){

                @Override
                protected void handleConnection(AFUNIXSocket socket) throws IOException {
                    socket.setOutboundFileDescriptors(new FileDescriptor[]{FileDescriptor.in, FileDescriptor.err});
                    try (AFOutputStream outputStream = socket.getOutputStream();){
                        outputStream.write(123);
                    }
                    this.stopAcceptingConnections();
                }
            };
                 AFUNIXSocket socket = (AFUNIXSocket)this.connectTo(serverThread.getServerAddress());
                 AFInputStream inputStream = socket.getInputStream();){
                try {
                    Assertions.assertEquals((int)123, (int)inputStream.read());
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                Assertions.assertArrayEquals((Object[])new FileDescriptor[0], (Object[])socket.getReceivedFileDescriptors());
                Assertions.assertEquals((int)0, (int)socket.getAncillaryReceiveBufferSize());
            }
        });
    }

    @Test
    public void testAncillaryReceiveBufferTooSmall() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            try (SocketTestBase.AFUNIXServerThread serverThread = new SocketTestBase.AFUNIXServerThread(){

                @Override
                protected void handleConnection(AFUNIXSocket socket) throws IOException {
                    block9: {
                        socket.setOutboundFileDescriptors(new FileDescriptor[]{FileDescriptor.in, FileDescriptor.err});
                        Assertions.assertTrue((boolean)socket.hasOutboundFileDescriptors());
                        try (AFOutputStream outputStream = socket.getOutputStream();){
                            try {
                                outputStream.write(123);
                            }
                            catch (SocketException e) {
                                if (!socket.isConnected()) {
                                    break block9;
                                }
                                throw e;
                            }
                        }
                    }
                    Assertions.assertFalse((boolean)socket.hasOutboundFileDescriptors());
                    this.stopAcceptingConnections();
                }
            };
                 AFUNIXSocket socket = (AFUNIXSocket)this.connectTo(serverThread.getServerAddress());
                 AFInputStream inputStream = socket.getInputStream();){
                ImplUtil.setAncillaryReceiveBufferSize(socket, 13);
                try {
                    Assertions.assertEquals((int)123, (int)inputStream.read());
                    FileDescriptor[] fds = socket.getReceivedFileDescriptors();
                    if (fds.length != 0) {
                        if (fds.length != 2) {
                            if (fds.length == 1) {
                                System.err.println("WARNING: Not all file descriptors were received");
                            } else {
                                Assertions.assertEquals((int)2, (int)fds.length, (String)"Received wrong number of file descriptors");
                            }
                        }
                    } else {
                        Assertions.fail((String)"Expected a \"No buffer space available\" SocketException");
                    }
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                Assertions.assertArrayEquals((Object[])new FileDescriptor[0], (Object[])socket.getReceivedFileDescriptors());
            }
        });
    }

    @Test
    public void testFileInputStream() throws Exception {
        final File tmpFile = SocketTestBase.newTempFile();
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            try (SocketTestBase.AFUNIXServerThread serverThread = new SocketTestBase.AFUNIXServerThread(this){
                final /* synthetic */ FileDescriptorsTest this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                protected void handleConnection(AFUNIXSocket socket) throws IOException {
                    try (FileOutputStream fos = new FileOutputStream(tmpFile);){
                        fos.write("WORLD!".getBytes(StandardCharsets.UTF_8));
                    }
                    try (FileInputStream fin = new FileInputStream(tmpFile);){
                        socket.setOutboundFileDescriptors(new FileDescriptor[]{fin.getFD()});
                        try (AFOutputStream outputStream = socket.getOutputStream();){
                            outputStream.write("HELLO".getBytes(StandardCharsets.UTF_8));
                        }
                    }
                    this.stopAcceptingConnections();
                }
            };
                 AFUNIXSocket socket = (AFUNIXSocket)this.connectTo(serverThread.getServerAddress());
                 AFInputStream in = socket.getInputStream();){
                socket.setAncillaryReceiveBufferSize(1024);
                byte[] buf = new byte[64];
                int numRead = in.read(buf);
                Assertions.assertEquals((int)5, (int)numRead, (String)"'HELLO' is five bytes long");
                Assertions.assertEquals((Object)"HELLO", (Object)new String(buf, 0, numRead, StandardCharsets.UTF_8));
                FileDescriptor[] fds = socket.getReceivedFileDescriptors();
                Assertions.assertEquals((int)1, (int)fds.length, (String)"Now, we should have two file descriptors");
                FileDescriptor fdesc = fds[0];
                try (FileInputStream fin = new FileInputStream(fdesc);){
                    numRead = fin.read(buf);
                    Assertions.assertEquals((int)6, (int)numRead, (String)"'WORLD!' is six bytes long");
                    Assertions.assertEquals((Object)"WORLD!", (Object)new String(buf, 0, numRead, StandardCharsets.UTF_8));
                }
            }
            finally {
                Files.deleteIfExists(tmpFile.toPath());
            }
        });
    }

    @Test
    public void testFileInputStreamPartiallyConsumed() throws Exception {
        final File tmpFile = SocketTestBase.newTempFile();
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            try (SocketTestBase.AFUNIXServerThread serverThread = new SocketTestBase.AFUNIXServerThread(this){
                final /* synthetic */ FileDescriptorsTest this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                protected void handleConnection(AFUNIXSocket socket) throws IOException {
                    try (FileOutputStream fos = new FileOutputStream(tmpFile);){
                        fos.write("WORLD!".getBytes(StandardCharsets.UTF_8));
                    }
                    try (FileInputStream fin = new FileInputStream(tmpFile);){
                        Assertions.assertEquals((int)87, (int)fin.read());
                        socket.setOutboundFileDescriptors(new FileDescriptor[]{fin.getFD()});
                        try (AFOutputStream outputStream = socket.getOutputStream();){
                            outputStream.write("HELLO".getBytes(StandardCharsets.UTF_8));
                        }
                    }
                    this.stopAcceptingConnections();
                }
            };
                 AFUNIXSocket socket = (AFUNIXSocket)this.connectTo(serverThread.getServerAddress());
                 AFInputStream in = socket.getInputStream();){
                socket.setAncillaryReceiveBufferSize(1024);
                byte[] buf = new byte[64];
                int numRead = in.read(buf);
                Assertions.assertEquals((int)5, (int)numRead, (String)"'HELLO' is five bytes long");
                Assertions.assertEquals((Object)"HELLO", (Object)new String(buf, 0, numRead, StandardCharsets.UTF_8));
                FileDescriptor[] fds = socket.getReceivedFileDescriptors();
                Assertions.assertEquals((int)1, (int)fds.length, (String)"Now, we should have two file descriptors");
                FileDescriptor fdesc = fds[0];
                try (FileInputStream fin = new FileInputStream(fdesc);){
                    numRead = fin.read(buf);
                    Assertions.assertEquals((int)5, (int)numRead, (String)"'ORLD!' is five bytes long");
                    Assertions.assertEquals((Object)"ORLD!", (Object)new String(buf, 0, numRead, StandardCharsets.UTF_8));
                }
            }
            finally {
                Files.deleteIfExists(tmpFile.toPath());
            }
        });
    }

    @AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNIX_DATAGRAMS})
    @Test
    public void testDatagramSocket() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(30L), () -> {
            AFUNIXSocketAddress ds1Addr = AFUNIXSocketAddress.of((File)FileDescriptorsTest.newTempFile());
            AFUNIXSocketAddress ds2Addr = AFUNIXSocketAddress.of((File)FileDescriptorsTest.newTempFile());
            try (AFUNIXDatagramSocket ds1 = AFUNIXDatagramSocket.newInstance();
                 AFUNIXDatagramSocket ds2 = AFUNIXDatagramSocket.newInstance();){
                ds1.setAncillaryReceiveBufferSize(1024);
                ds2.setAncillaryReceiveBufferSize(1024);
                ds1.bind((SocketAddress)ds1Addr);
                ds2.bind((SocketAddress)ds2Addr);
                ds1.connect((SocketAddress)ds2Addr);
                ds2.connect((SocketAddress)ds1Addr);
                File tmpOut = FileDescriptorsTest.newTempFile();
                try (FileOutputStream fos = new FileOutputStream(tmpOut);){
                    ds1.setOutboundFileDescriptors(new FileDescriptor[]{fos.getFD()});
                    DatagramPacket dp = AFDatagramUtil.datagramWithCapacity(64);
                    Assertions.assertTrue((boolean)ds1.hasOutboundFileDescriptors());
                    ds1.send(dp);
                    Assertions.assertFalse((boolean)ds1.hasOutboundFileDescriptors());
                    ds2.receive(dp);
                    FileDescriptor[] fds = ds2.getReceivedFileDescriptors();
                    Assertions.assertEquals((int)1, (int)fds.length);
                    try (FileOutputStream fos2 = new FileOutputStream(fds[0]);){
                        fos2.write("Hello".getBytes(StandardCharsets.UTF_8));
                    }
                    fos.write("World".getBytes(StandardCharsets.UTF_8));
                }
                try (FileInputStream fin = new FileInputStream(tmpOut);){
                    String text = new String(IOUtil.readAllBytes((InputStream)fin), StandardCharsets.UTF_8);
                    Assertions.assertEquals((Object)"HelloWorld", (Object)text);
                }
            }
        });
    }
}

