/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.domain;

import com.kohlschutter.testutil.AvailabilityRequirement;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.ThroughputTest;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class ThroughputTestShim
extends ThroughputTest<AFUNIXSocketAddress> {
    protected ThroughputTestShim(AddressSpecifics<AFUNIXSocketAddress> asp) {
        super(asp);
    }

    @Test
    @AvailabilityRequirement(classes={"java.net.UnixDomainSocketAddress"}, message="This test requires Java 16 or later")
    public void testJEP380() throws Exception {
        this.testJEP380(false);
    }

    @Test
    @AvailabilityRequirement(classes={"java.net.UnixDomainSocketAddress"}, message="This test requires Java 16 or later")
    public void testJEP380direct() throws Exception {
        this.testJEP380(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testJEP380(boolean direct) throws Exception {
        Path p = ThroughputTestShim.newTempFile().toPath();
        try {
            UnixDomainSocketAddress usa = UnixDomainSocketAddress.of(p);
            ServerSocketChannel ssc = ServerSocketChannel.open(StandardProtocolFamily.UNIX);
            this.runTestSocketChannel("JEP380 SocketChannel", usa, ssc, () -> {
                SocketChannel sc = SocketChannel.open(StandardProtocolFamily.UNIX);
                this.connectSocket(sc, ssc.getLocalAddress());
                return sc;
            }, direct);
        }
        finally {
            Files.delete(p);
        }
    }
}

