/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.domain;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketCapabilityRequirement;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.domain.AFUNIXAddressSpecifics;
import org.opentest4j.TestAbortedException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNIX_DOMAIN})
@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"})
public final class FinalizeTest
extends org.newsclub.net.unix.FinalizeTest<AFUNIXSocketAddress> {
    public FinalizeTest() {
        super(AFUNIXAddressSpecifics.INSTANCE);
    }

    @Override
    protected String socketType() {
        return "UNIX";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"RV_DONT_JUST_NULL_CHECK_READLINE"})
    private static List<String> lsofUnixSockets(long pid) throws IOException, TestAbortedException, InterruptedException {
        Process p;
        Assertions.assertTrue((pid > 0L ? 1 : 0) != 0);
        ArrayList<String> lines = new ArrayList<String>();
        try {
            p = Runtime.getRuntime().exec(new String[]{"lsof", "-U", "-a", "-p", String.valueOf(pid)});
        }
        catch (Exception e) {
            Assumptions.assumeTrue((boolean)false, (String)e.getMessage());
            return Collections.emptyList();
        }
        try {
            try (BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream(), Charset.defaultCharset()));){
                String l;
                boolean hasUnix = false;
                while ((l = in.readLine()) != null) {
                    lines.add(l);
                    if (!hasUnix && l.contains("unix")) {
                        hasUnix = true;
                    }
                    if (!l.contains("busybox")) continue;
                    Assumptions.assumeTrue((boolean)false, (String)"incompatible lsof binary");
                }
                if (hasUnix) {
                    Iterator it = lines.iterator();
                    while (it.hasNext()) {
                        String line = (String)it.next();
                        if (line.contains("unix")) continue;
                        it.remove();
                    }
                }
                p.waitFor();
            }
            p.destroy();
            Assumptions.assumeTrue((p.exitValue() == 0 ? 1 : 0) != 0, (String)"lsof should terminate with RC=0");
        }
        catch (Throwable throwable) {
            p.destroy();
            Assumptions.assumeTrue((p.exitValue() == 0 ? 1 : 0) != 0, (String)"lsof should terminate with RC=0");
            throw throwable;
        }
        return lines;
    }

    @Override
    protected Object preRunCheck(Process process) throws TestAbortedException, IOException, InterruptedException {
        List<String> linesBefore = FinalizeTest.lsofUnixSockets(process.pid());
        Assumptions.assumeTrue((!linesBefore.isEmpty() ? 1 : 0) != 0);
        return linesBefore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"DM_GC"})
    protected void postRunCheck(Process process, Object linesBeforeObj) throws TestAbortedException, IOException, InterruptedException {
        Assumptions.assumeTrue((linesBeforeObj != null ? 1 : 0) != 0, (String)"Environment does not support lsof check");
        List linesBefore = (List)linesBeforeObj;
        try {
            List<String> linesAfter = null;
            for (int i = 0; i < 50; ++i) {
                Thread.sleep(100L);
                if (!process.isAlive()) break;
                if (i == 20) {
                    System.gc();
                }
                linesAfter = FinalizeTest.lsofUnixSockets(process.pid());
                if (linesBefore == null || linesAfter.size() < linesBefore.size()) break;
            }
            if (linesAfter != null && linesBefore != null && !linesBefore.isEmpty() && !linesAfter.isEmpty()) {
                if (linesAfter.size() >= linesBefore.size()) {
                    System.err.println("lsof: Unexpected output");
                    System.err.println("lsof: Output before: " + String.valueOf(linesBefore));
                    System.err.println("lsof: Output after: " + String.valueOf(linesAfter));
                }
                Assertions.assertTrue((linesAfter.size() < linesBefore.size() ? 1 : 0) != 0, (String)"Our unix socket file handle should have been cleared out");
            }
        }
        finally {
            process.destroy();
            process.waitFor();
        }
    }
}

