/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFServerSocket;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
public abstract class ServerSocketTest<A extends SocketAddress>
extends SocketTestBase<A> {
    protected ServerSocketTest(AddressSpecifics<A> asp) {
        super(asp);
    }

    @Test
    public void testSupported() throws Exception {
        Assertions.assertTrue((boolean)AFServerSocket.isSupported());
    }

    @Test
    public void testCloseable() throws Exception {
        final AtomicBoolean closed = new AtomicBoolean(false);
        Closeable closeable = new Closeable(){
            final /* synthetic */ ServerSocketTest this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void close() throws IOException {
                closed.set(true);
            }
        };
        try (AFServerSocket socket = (AFServerSocket)this.newServerSocket();){
            socket.addCloseable(null);
            socket.addCloseable(closeable);
            socket.removeCloseable(null);
            socket.removeCloseable(closeable);
        }
        Assertions.assertFalse((boolean)closed.get());
        socket = (AFServerSocket)this.newServerSocket();
        try {
            socket.addCloseable(closeable);
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
        Assertions.assertTrue((boolean)closed.get());
    }

    @Test
    public void testBindBadArguments() throws Exception {
        try (ServerSocket sock = this.newServerSocket();){
            Assertions.assertFalse((boolean)sock.isBound());
            try {
                sock.bind(null);
            }
            catch (UnsupportedOperationException e) {
                Assertions.assertFalse((boolean)sock.isBound());
            }
        }
        sock = this.newServerSocket();
        try {
            Assertions.assertFalse((boolean)sock.isBound());
            Assertions.assertThrows(IllegalArgumentException.class, () -> sock.bind(new InetSocketAddress("", 0)));
            Assertions.assertFalse((boolean)sock.isBound());
        }
        finally {
            if (sock != null) {
                sock.close();
            }
        }
    }

    @Test
    public void testUnboundServerSocket() throws IOException {
        try (ServerSocket socket = this.newServerSocket();){
            Assertions.assertTrue((socket.getReceiveBufferSize() > 0 ? 1 : 0) != 0);
        }
    }
}

