/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.tipc;

import com.kohlschutter.util.ProcessUtil;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicInteger;
import org.newsclub.net.unix.AFDatagramSocket;
import org.newsclub.net.unix.AFSelectorProvider;
import org.newsclub.net.unix.AFServerSocket;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFTIPCSocketAddress;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.CloseablePair;
import org.newsclub.net.unix.tipc.AFTIPCDatagramSocket;
import org.newsclub.net.unix.tipc.AFTIPCSelectorProvider;
import org.newsclub.net.unix.tipc.AFTIPCServerSocket;
import org.newsclub.net.unix.tipc.AFTIPCServerSocketChannel;
import org.newsclub.net.unix.tipc.AFTIPCSocket;
import org.newsclub.net.unix.tipc.AFTIPCSocketChannel;
import org.newsclub.net.unix.tipc.AFTIPCSocketPair;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AFTIPCAddressSpecifics
implements AddressSpecifics<AFTIPCSocketAddress> {
    private static final int TIPC_TYPE = (int)(ProcessUtil.getPid() % Integer.MAX_VALUE) + 64;
    private static final AtomicInteger INSTANCE_COUNTER = new AtomicInteger(0);
    public static final AddressSpecifics<AFTIPCSocketAddress> INSTANCE = new AFTIPCAddressSpecifics();

    private AFTIPCAddressSpecifics() {
    }

    public AFSocketAddress newTempAddress() throws IOException {
        return AFTIPCSocketAddress.ofService((AFTIPCSocketAddress.Scope)AFTIPCSocketAddress.Scope.SCOPE_NODE, (int)TIPC_TYPE, (int)INSTANCE_COUNTER.incrementAndGet());
    }

    public AFSocket<?> newSocket() throws IOException {
        return AFTIPCSocket.newInstance();
    }

    public AFSocket<?> newStrictSocket() throws IOException {
        return AFTIPCSocket.newStrictInstance();
    }

    @Override
    public SocketChannel newSocketChannel() throws IOException {
        return AFTIPCSocketChannel.open();
    }

    public AFDatagramSocket<?> newDatagramSocket() throws IOException {
        return AFTIPCDatagramSocket.newInstance();
    }

    @Override
    public DatagramChannel newDatagramChannel() throws IOException {
        return AFTIPCDatagramSocket.newInstance().getChannel();
    }

    public AFServerSocket<?> newServerSocket() throws IOException {
        return AFTIPCServerSocket.newInstance();
    }

    public AFSocketAddress newTempAddressForDatagram() throws IOException {
        return AFTIPCSocketAddress.ofService((AFTIPCSocketAddress.Scope)AFTIPCSocketAddress.Scope.SCOPE_NODE, (int)TIPC_TYPE, (int)INSTANCE_COUNTER.incrementAndGet());
    }

    public AFSocketAddress unwrap(InetAddress addr, int port) throws SocketException {
        return AFTIPCSocketAddress.unwrap((InetAddress)addr, (int)port);
    }

    public AFSelectorProvider<?> selectorProvider() {
        return AFTIPCSelectorProvider.provider();
    }

    @Override
    public CloseablePair<? extends SocketChannel> newSocketPair() throws IOException {
        return AFTIPCSocketPair.open();
    }

    @Override
    public CloseablePair<? extends DatagramChannel> newDatagramSocketPair() throws IOException {
        return AFTIPCSocketPair.openDatagram();
    }

    public AFServerSocket<?> newServerSocketBindOn(SocketAddress addr) throws IOException {
        return AFTIPCServerSocket.bindOn((AFTIPCSocketAddress)((AFTIPCSocketAddress)addr));
    }

    @Override
    public Socket connectTo(SocketAddress socket) throws IOException {
        return AFTIPCSocket.connectTo((AFTIPCSocketAddress)((AFTIPCSocketAddress)socket));
    }

    public AFServerSocket<?> newServerSocketBindOn(SocketAddress addr, boolean deleteOnClose) throws IOException {
        return AFTIPCServerSocket.bindOn((AFTIPCSocketAddress)((AFTIPCSocketAddress)addr), (boolean)deleteOnClose);
    }

    @Override
    public CloseablePair<? extends Socket> newInterconnectedSockets() throws IOException {
        CloseablePair<? extends SocketChannel> sp = this.newSocketPair();
        return new CloseablePair((Closeable)((SocketChannel)sp.getFirst()).socket(), (Closeable)((SocketChannel)sp.getSecond()).socket());
    }

    @Override
    public String addressFamilyString() {
        return "AF_TIPC";
    }

    @Override
    public String summaryImportantMessage(String message) {
        return message;
    }

    @Override
    public ServerSocketChannel newServerSocketChannel() throws IOException {
        return AFTIPCServerSocketChannel.open();
    }
}

