/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.ssl;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.testutil.AssertUtil;
import com.kohlschutter.testutil.TestAbortedWithImportantMessageException;
import com.kohlschutter.testutil.TestResourceUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketFactory;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketChannel;
import org.newsclub.net.unix.AFUNIXSocketPair;
import org.newsclub.net.unix.KnownJavaBugIOException;
import org.newsclub.net.unix.ssl.IgnorantX509TrustManager;
import org.newsclub.net.unix.ssl.SSLContextBuilder;
import org.newsclub.net.unix.ssl.SSLParametersUtil;
import org.newsclub.net.unix.ssl.SSLSupplier;
import org.newsclub.net.unix.ssl.SSLTestBase;
import org.newsclub.net.unix.ssl.TestUtil;
import org.newsclub.net.unix.ssl.TestingAFSocketServer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SSLContextBuilderTest
extends SSLTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testNoClientAuth(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLSocketFactory clientSocketFactory;
        SSLSocketFactory serverSocketFactory;
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.ofNewTempFile();
        try {
            serverSocketFactory = configuration.configure(SSLContextBuilder.forServer()).withKeyStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxserver.p12"), "serverpass"::toCharArray).withDefaultSSLParameters(p -> {
                SSLParametersUtil.disableCipherSuites((SSLParameters)p, (String[])new String[]{"SOME_REALLY_BAD_CIPHER"});
                SSLParametersUtil.disableProtocols((SSLParameters)p, (String[])new String[]{"TLSv1.0", "TLSv1.1"});
            }).buildAndDestroyBuilder().getSocketFactory();
            clientSocketFactory = configuration.configure(SSLContextBuilder.forClient()).withTrustStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxclient.truststore"), "clienttrustpass"::toCharArray).buildAndDestroyBuilder().getSocketFactory();
        }
        catch (KnownJavaBugIOException e) {
            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
        }
        CompletableFuture serverException = new CompletableFuture();
        CompletableFuture clientException = new CompletableFuture();
        try {
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> this.runServerAndClient(addr, serverSocketFactory, clientSocketFactory, serverException, clientException, false));
            Assertions.assertNull(serverException.get());
            Assertions.assertNull(clientException.get());
        }
        finally {
            Files.deleteIfExists(addr.getFile().toPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testClientAuthRequired(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLSocketFactory clientSocketFactory;
        SSLSocketFactory serverSocketFactory;
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.ofNewTempFile();
        try {
            serverSocketFactory = configuration.configure(SSLContextBuilder.forServer()).withKeyStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxserver.p12"), "serverpass"::toCharArray).withTrustStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxserver.truststore"), "servertrustpass"::toCharArray).withDefaultSSLParameters(p -> p.setNeedClientAuth(true)).buildAndDestroyBuilder().getSocketFactory();
            clientSocketFactory = configuration.configure(SSLContextBuilder.forClient()).withKeyStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxclient.p12"), "clientpass"::toCharArray).withTrustStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxclient.truststore"), "clienttrustpass"::toCharArray).buildAndDestroyBuilder().getSocketFactory();
        }
        catch (KnownJavaBugIOException e) {
            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
        }
        CompletableFuture serverException = new CompletableFuture();
        CompletableFuture clientException = new CompletableFuture();
        try {
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
                this.runServerAndClient(addr, serverSocketFactory, clientSocketFactory, serverException, clientException, false);
                Assertions.assertNull(serverException.get());
                Assertions.assertNull(clientException.get());
            });
        }
        finally {
            Files.deleteIfExists(addr.getFile().toPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testClientAuthRequiredButClientIsNotSendingAKey(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLSocketFactory clientSocketFactory;
        SSLSocketFactory serverSocketFactory;
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.ofNewTempFile();
        try {
            serverSocketFactory = configuration.configure(SSLContextBuilder.forServer()).withKeyStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxserver.p12"), "serverpass"::toCharArray).withDefaultSSLParameters(p -> p.setNeedClientAuth(true)).buildAndDestroyBuilder().getSocketFactory();
            clientSocketFactory = configuration.configure(SSLContextBuilder.forClient()).withTrustStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxclient.truststore"), "clienttrustpass"::toCharArray).buildAndDestroyBuilder().getSocketFactory();
        }
        catch (KnownJavaBugIOException e) {
            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
        }
        CompletableFuture serverException = new CompletableFuture();
        CompletableFuture clientException = new CompletableFuture();
        try {
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
                Assertions.assertThrows(IOException.class, () -> this.runServerAndClient(addr, serverSocketFactory, clientSocketFactory, serverException, clientException, true));
                AssertUtil.assertInstanceOf((Throwable)((Throwable)serverException.get()), (Class[])new Class[]{SSLHandshakeException.class, SocketException.class, SSLProtocolException.class, BOUNCYCASTLE_TLS_EXCEPTION, SSLException.class});
                AssertUtil.assertInstanceOf((Throwable)((Throwable)clientException.get()), (Class[])new Class[]{null, SSLHandshakeException.class, SocketException.class, SSLProtocolException.class, BOUNCYCASTLE_TLS_EXCEPTION, SSLException.class});
            });
        }
        finally {
            Files.deleteIfExists(addr.getFile().toPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testClientAuthRequiredButClientKeyIsNotTrusted(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLSocketFactory clientSocketFactory;
        SSLSocketFactory serverSocketFactory;
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.ofNewTempFile();
        try {
            serverSocketFactory = configuration.configure(SSLContextBuilder.forServer()).withKeyStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxserver.p12"), "serverpass"::toCharArray).withDefaultSSLParameters(p -> p.setNeedClientAuth(true)).buildAndDestroyBuilder().getSocketFactory();
            clientSocketFactory = configuration.configure(SSLContextBuilder.forClient()).withKeyStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxclient.p12"), "clientpass"::toCharArray).withTrustStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxclient.truststore"), "clienttrustpass"::toCharArray).buildAndDestroyBuilder().getSocketFactory();
        }
        catch (KnownJavaBugIOException e) {
            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
        }
        CompletableFuture serverException = new CompletableFuture();
        CompletableFuture clientException = new CompletableFuture();
        try {
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
                Assertions.assertThrows(IOException.class, () -> this.runServerAndClient(addr, serverSocketFactory, clientSocketFactory, serverException, clientException, true));
                AssertUtil.assertInstanceOf((Throwable)((Throwable)serverException.get()), (Class[])new Class[]{SSLHandshakeException.class, SocketException.class, SSLProtocolException.class, BOUNCYCASTLE_TLS_EXCEPTION, SSLException.class});
                AssertUtil.assertInstanceOf((Throwable)((Throwable)clientException.get()), (Class[])new Class[]{null, SSLHandshakeException.class, SocketException.class, SSLProtocolException.class, BOUNCYCASTLE_TLS_EXCEPTION, SSLException.class});
            });
        }
        finally {
            Files.deleteIfExists(addr.getFile().toPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testClientHasNoTrustStore(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLSocketFactory clientSocketFactory;
        SSLSocketFactory serverSocketFactory;
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.ofNewTempFile();
        try {
            serverSocketFactory = configuration.configure(SSLContextBuilder.forServer()).withKeyStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxserver.p12"), "serverpass"::toCharArray).withSecureRandom(null).withDefaultSSLParameters(p -> {}).buildAndDestroyBuilder().getSocketFactory();
            clientSocketFactory = configuration.configure(SSLContextBuilder.forClient()).buildAndDestroyBuilder().getSocketFactory();
        }
        catch (KnownJavaBugIOException e) {
            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
        }
        CompletableFuture serverException = new CompletableFuture();
        CompletableFuture clientException = new CompletableFuture();
        try {
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
                Assertions.assertThrows(IOException.class, () -> this.runServerAndClient(addr, serverSocketFactory, clientSocketFactory, serverException, clientException, true));
                AssertUtil.assertInstanceOf((Throwable)((Throwable)serverException.get()), (Class[])new Class[]{SSLHandshakeException.class, SocketException.class, SSLProtocolException.class, BOUNCYCASTLE_TLS_EXCEPTION, SSLException.class});
                AssertUtil.assertInstanceOf((Throwable)((Throwable)clientException.get()), (Class[])new Class[]{null, SSLHandshakeException.class, SocketException.class, SSLProtocolException.class, BOUNCYCASTLE_TLS_EXCEPTION, SSLException.class});
            });
        }
        finally {
            Files.deleteIfExists(addr.getFile().toPath());
        }
    }

    /*
     * Exception decompiling
     */
    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testServerAndClientBlindlyTrustAnything(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runServerAndClient(AFUNIXSocketAddress addr, final SSLSocketFactory serverSocketFactory, SSLSocketFactory clientSocketFactory, final CompletableFuture<Exception> serverException, CompletableFuture<Exception> clientException, boolean expectClientTrouble) throws Exception {
        block36: {
            TestingAFSocketServer<AFUNIXSocketAddress> server = new TestingAFSocketServer<AFUNIXSocketAddress>(this, addr){
                final /* synthetic */ SSLContextBuilderTest this$0;
                {
                    this.this$0 = this$0;
                    super(listenAddress);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void doServeSocket(AFSocket<? extends AFUNIXSocketAddress> plainSocket) throws IOException {
                    Exception caught = null;
                    try (SSLSocket sslSocket = (SSLSocket)serverSocketFactory.createSocket((Socket)plainSocket, "localhost.junixsocket", plainSocket.getPort(), false);
                         InputStream in = sslSocket.getInputStream();
                         OutputStream out = sslSocket.getOutputStream();){
                        int v = in.read();
                        Assertions.assertEquals((int)33, (int)v);
                        out.write("Hello World".getBytes(StandardCharsets.UTF_8));
                        out.flush();
                    }
                    catch (Exception e) {
                        caught = e;
                    }
                    finally {
                        serverException.complete(caught);
                    }
                }
            };
            try {
                server.startAndWaitToBecomeReady();
                Exception caught = null;
                try (AFUNIXSocket plainSocket = AFUNIXSocket.connectTo((AFUNIXSocketAddress)addr);
                     SSLSocket sslSocket = (SSLSocket)clientSocketFactory.createSocket((Socket)plainSocket, "localhost.junixsocket", plainSocket.getPort(), false);){
                    try (InputStream in = sslSocket.getInputStream();
                         OutputStream out = sslSocket.getOutputStream();){
                        int offset;
                        int r;
                        out.write(33);
                        out.flush();
                        byte[] by = new byte[11];
                        for (offset = 0; offset < by.length && (r = in.read(by, offset, by.length - offset)) >= 0; offset += r) {
                        }
                        Assertions.assertEquals((Object)"Hello World", (Object)new String(by, 0, offset, StandardCharsets.UTF_8));
                    }
                    catch (SocketException e) {
                        if (expectClientTrouble) {
                            break block36;
                        }
                        throw e;
                    }
                }
                catch (Exception e) {
                    caught = e;
                }
                finally {
                    clientException.complete(caught);
                }
            }
            finally {
                server.stop();
                TestUtil.throwMoreInterestingThrowableThanSocketException(() -> serverException.getNow(null), () -> clientException.getNow(null));
                server.checkThrowable();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testDestroyablePasswordSupplier(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        DestroyablePasswordSupplier dps = new DestroyablePasswordSupplier();
        SSLContextBuilder builder = configuration.configure(SSLContextBuilder.forServer()).withKeyStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxserver.p12"), (SSLSupplier)dps).withDefaultSSLParameters(p -> {});
        try {
            builder.build();
        }
        catch (KnownJavaBugIOException e) {
            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
        }
        Assertions.assertFalse((boolean)dps.isDestroyed());
        builder.destroy();
        Assertions.assertTrue((boolean)dps.isDestroyed());
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testDestroyablePasswordSupplierDestroyed(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        DestroyablePasswordSupplier dps = new DestroyablePasswordSupplier();
        SSLContextBuilder builder = configuration.configure(SSLContextBuilder.forServer()).withKeyStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxserver.p12"), (SSLSupplier)dps).withDefaultSSLParameters(p -> {});
        try {
            builder.build();
        }
        catch (KnownJavaBugIOException e) {
            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
        }
        Assertions.assertFalse((boolean)dps.isDestroyed());
        dps.destroy();
        Assertions.assertTrue((boolean)dps.isDestroyed());
        builder.destroy();
        Assertions.assertTrue((boolean)dps.isDestroyed());
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testUndestroyablePasswordSupplier(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        UndestroyablePasswordSupplier dps = new UndestroyablePasswordSupplier();
        SSLContextBuilder builder = configuration.configure(SSLContextBuilder.forServer()).withKeyStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxserver.p12"), (SSLSupplier)dps).withDefaultSSLParameters(p -> {});
        try {
            builder.build();
        }
        catch (KnownJavaBugIOException e) {
            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
        }
        Assertions.assertFalse((boolean)dps.isDestroyed());
        Assertions.assertThrows(DestroyFailedException.class, () -> ((SSLContextBuilder)builder).destroy());
        Assertions.assertFalse((boolean)dps.isDestroyed());
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testUndestroyablePasswordSuppliers(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        UndestroyablePasswordSupplier dps = new UndestroyablePasswordSupplier();
        SSLContextBuilder builder = configuration.configure(SSLContextBuilder.forServer()).withKeyStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxserver.p12"), (SSLSupplier)dps).withTrustStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxserver.p12"), (SSLSupplier)dps).withDefaultSSLParameters(p -> {});
        try {
            builder.build();
        }
        catch (KnownJavaBugIOException e) {
            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
        }
        Assertions.assertFalse((boolean)dps.isDestroyed());
        try {
            builder.destroy();
            Assertions.fail((String)("Expected " + String.valueOf(DestroyFailedException.class)));
        }
        catch (DestroyFailedException e) {
            Throwable[] suppressed = e.getSuppressed();
            Assertions.assertEquals((int)1, (int)suppressed.length);
            AssertUtil.assertInstanceOf((Throwable)suppressed[0], (Class[])new Class[]{DestroyFailedException.class});
        }
        Assertions.assertFalse((boolean)dps.isDestroyed());
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"})
    public void testKeyStoreNullPasswordSupplied(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLContextBuilder builder = configuration.configure(SSLContextBuilder.forServer()).withKeyStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxserver.p12"), () -> null).withDefaultSSLParameters(p -> {});
        boolean fail = true;
        try {
            builder.build();
        }
        catch (NullPointerException | UnrecoverableKeyException | KnownJavaBugIOException e) {
            fail = false;
        }
        if (fail) {
            Assertions.fail((String)"Should have thrown an UnrecoverableKeyException or NullPointerException");
        }
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"})
    public void testKeyStoreNullPasswordSupplier(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLContextBuilder builder = configuration.configure(SSLContextBuilder.forServer()).withKeyStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxserver.p12"), null).withDefaultSSLParameters(p -> {});
        boolean fail = true;
        try {
            builder.build();
        }
        catch (NullPointerException | UnrecoverableKeyException | KnownJavaBugIOException e) {
            fail = false;
        }
        if (fail) {
            Assertions.fail((String)"Should have thrown an UnrecoverableKeyException or NullPointerException");
        }
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testKeyStoreNullURL(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLContextBuilder builder = configuration.configure(SSLContextBuilder.forServer());
        Assertions.assertThrows(NullPointerException.class, () -> builder.withKeyStore((URL)null, "serverpass"::toCharArray));
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testKeyStoreURLNotFound(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLContextBuilder builder = configuration.configure(SSLContextBuilder.forServer());
        File f = File.createTempFile("test", ".jux");
        Files.delete(f.toPath());
        builder.withKeyStore(f.toURI().toURL(), "serverpass"::toCharArray);
        Assertions.assertThrows(FileNotFoundException.class, () -> {
            try {
                builder.build();
            }
            catch (KnownJavaBugIOException e) {
                throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
            }
        });
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testKeyStoreFileNotFound(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLContextBuilder builder = configuration.configure(SSLContextBuilder.forServer());
        File f = File.createTempFile("test", ".jux");
        Files.delete(f.toPath());
        builder.withKeyStore(f, "serverpass"::toCharArray);
        Assertions.assertThrows(FileNotFoundException.class, () -> {
            try {
                builder.build();
            }
            catch (KnownJavaBugIOException e) {
                throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
            }
        });
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testTrustStoreNullPasswordSupplied(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLContextBuilder builder = configuration.configure(SSLContextBuilder.forServer()).withTrustStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxserver.truststore"), () -> null).withDefaultSSLParameters(p -> {});
        SSLContextBuilderTest.assertNoExceptionOrNullPointerException(() -> {
            try {
                return builder.build();
            }
            catch (KnownJavaBugIOException e) {
                throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
            }
        });
    }

    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"})
    private static void assertNoExceptionOrNullPointerException(Callable<?> op) throws Exception {
        try {
            op.call();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testTrustStoreNullPasswordSupplier(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLContextBuilder builder = configuration.configure(SSLContextBuilder.forServer()).withTrustStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxserver.truststore"), null).withDefaultSSLParameters(p -> {});
        SSLContextBuilderTest.assertNoExceptionOrNullPointerException(() -> {
            try {
                return builder.build();
            }
            catch (KnownJavaBugIOException e) {
                throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
            }
        });
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testTrustStoreNullURL(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLContextBuilder builder = configuration.configure(SSLContextBuilder.forServer());
        Assertions.assertThrows(NullPointerException.class, () -> builder.withTrustStore((URL)null, "servertrustpass"::toCharArray));
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testTrustStoreURLNotFound(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLContextBuilder builder = configuration.configure(SSLContextBuilder.forServer());
        File f = File.createTempFile("test", ".jux");
        Files.delete(f.toPath());
        builder.withTrustStore(f.toURI().toURL(), "servertrustpass"::toCharArray);
        Assertions.assertThrows(FileNotFoundException.class, () -> {
            try {
                builder.build();
            }
            catch (KnownJavaBugIOException e) {
                throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
            }
        });
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testTrustStoreFileNotFound(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLContextBuilder builder = configuration.configure(SSLContextBuilder.forServer());
        File f = File.createTempFile("test", ".jux");
        Files.delete(f.toPath());
        builder.withTrustStore(f, "servertrustpass"::toCharArray);
        Assertions.assertThrows(FileNotFoundException.class, () -> {
            try {
                builder.build();
            }
            catch (KnownJavaBugIOException e) {
                throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
            }
        });
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testBadProtocol(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLContextBuilder builder = configuration.configure(SSLContextBuilder.forClient()).withProtocol("UnknownProtocol/UnitTesting");
        Assertions.assertThrows(NoSuchAlgorithmException.class, () -> {
            try {
                builder.build();
            }
            catch (KnownJavaBugIOException e) {
                throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
            }
        });
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testBothKeyStoreAndKeyManagers(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLContextBuilder builder = configuration.configure(SSLContextBuilder.forServer());
        builder.withKeyStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxserver.p12"), "serverpass"::toCharArray);
        Assertions.assertThrows(IllegalStateException.class, () -> builder.withKeyManagers(kmf -> {
            kmf.init(null, null);
            return kmf.getKeyManagers();
        }));
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testBothKeyManagersAndKeyStore(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLContextBuilder builder = configuration.configure(SSLContextBuilder.forServer());
        builder.withKeyManagers(kmf -> {
            kmf.init(null, null);
            return kmf.getKeyManagers();
        });
        Assertions.assertThrows(IllegalStateException.class, () -> builder.withKeyStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxserver.p12"), "serverpass"::toCharArray));
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testBothTrustStoreAndTrustManagers(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLContextBuilder builder = configuration.configure(SSLContextBuilder.forServer());
        builder.withTrustStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxserver.truststore"), "servertrustpass"::toCharArray);
        Assertions.assertThrows(IllegalStateException.class, () -> builder.withTrustManagers(tmf -> {
            tmf.init((KeyStore)null);
            return tmf.getTrustManagers();
        }));
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testBothTrustManagersAndTrustStore(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLContextBuilder builder = configuration.configure(SSLContextBuilder.forServer());
        builder.withTrustManagers(tmf -> {
            tmf.init((KeyStore)null);
            return tmf.getTrustManagers();
        });
        Assertions.assertThrows(IllegalStateException.class, () -> builder.withTrustStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxserver.truststore"), "servertrustpass"::toCharArray));
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testWithDefaultParameters1(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLContextBuilder builder = configuration.configure(SSLContextBuilder.forServer());
        builder.withDefaultSSLParameters(p -> Assertions.assertNotNull((Object)p));
        Assertions.assertThrows(IllegalStateException.class, () -> builder.withDefaultSSLParameters(p -> {
            Assertions.assertNotNull((Object)p);
            return p;
        }));
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testWithDefaultParameters2(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLContextBuilder builder = configuration.configure(SSLContextBuilder.forServer());
        builder.withDefaultSSLParameters(p -> {
            Assertions.assertNotNull((Object)p);
            return p;
        });
        Assertions.assertThrows(IllegalStateException.class, () -> builder.withDefaultSSLParameters(p -> Assertions.assertNotNull((Object)p)));
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testSocketFactoryMethods(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLSocketFactory factory;
        try {
            factory = configuration.configure(SSLContextBuilder.forServer()).withKeyStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxserver.p12"), "serverpass"::toCharArray).buildAndDestroyBuilder().getSocketFactory();
        }
        catch (KnownJavaBugIOException e) {
            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
        }
        Assertions.assertThrows(SocketException.class, factory::createSocket, (String)"Creating unconnected sockets is not supported, as they're very difficult to wrap");
        AFSocket someSocket = ((AFUNIXSocketChannel)AFUNIXSocketPair.open().getFirst()).socket();
        SSLSocket sslSocket = null;
        try {
            sslSocket = (SSLSocket)factory.createSocket((Socket)someSocket, null, false);
            Assertions.assertNotNull((Object)sslSocket);
            Assertions.assertTrue((boolean)sslSocket.isConnected());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        sslSocket = (SSLSocket)factory.createSocket((Socket)someSocket, "some.ignored.host.identifier", 123, false);
        Assertions.assertNotNull((Object)sslSocket);
        Assertions.assertTrue((boolean)sslSocket.isConnected());
        Assertions.assertNotEquals((int)0, (int)factory.getDefaultCipherSuites().length);
        Assertions.assertNotEquals((int)0, (int)factory.getSupportedCipherSuites().length);
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testSocketFactoryMethodsForCodeCoverageOnly(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        AFUNIXSocketAddress address = AFUNIXSocketAddress.ofNewTempFile();
        AtomicBoolean stop = new AtomicBoolean(false);
        Semaphore sema = new Semaphore(0);
        try (AFUNIXServerSocket server = AFUNIXServerSocket.bindOn((AFUNIXSocketAddress)address);){
            SSLSocketFactory factory;
            CompletableFuture<Exception> serverError = CompletableFuture.supplyAsync(() -> {
                while (!server.isClosed() && !stop.get()) {
                    try {
                        AFUNIXSocket unused = server.accept();
                        try {
                            sema.acquire();
                        }
                        finally {
                            if (unused == null) continue;
                            unused.close();
                        }
                    }
                    catch (IOException | InterruptedException e) {
                        return e;
                    }
                }
                return null;
            });
            try {
                factory = configuration.configure(SSLContextBuilder.forServer()).withKeyStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxserver.p12"), "serverpass"::toCharArray).withSocketFactory((SocketFactory)new AFSocketFactory.FixedAddressSocketFactory((SocketAddress)address)).buildAndDestroyBuilder().getSocketFactory();
            }
            catch (KnownJavaBugIOException e) {
                throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
            }
            InetAddress loopback = InetAddress.getLoopbackAddress();
            try (ServerSocket ss = new ServerSocket(0, 50, loopback);){
                factory.createSocket(loopback.getHostAddress(), ss.getLocalPort());
                sema.release();
                factory.createSocket(loopback, ss.getLocalPort());
                sema.release();
                factory.createSocket(loopback.getHostAddress(), ss.getLocalPort(), loopback, 0);
                sema.release();
                factory.createSocket(loopback, ss.getLocalPort(), loopback, 0);
                stop.set(true);
                sema.release();
            }
            try {
                serverError.get(10L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_INFORMATIONAL, "An code-coverage-only test timed out", (Throwable)e);
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testServerSocketFactoryMethods(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLServerSocketFactory factory;
        try {
            factory = configuration.configure(SSLContextBuilder.forServer()).withKeyStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxserver.p12"), "serverpass"::toCharArray).buildAndDestroyBuilder().getServerSocketFactory();
        }
        catch (KnownJavaBugIOException e) {
            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
        }
        Assertions.assertNotEquals((int)0, (int)factory.getDefaultCipherSuites().length);
        Assertions.assertNotEquals((int)0, (int)factory.getSupportedCipherSuites().length);
        Assertions.assertNotNull((Object)factory.createServerSocket());
        SSLServerSocket serverSocket = (SSLServerSocket)factory.createServerSocket();
        Assertions.assertFalse((boolean)serverSocket.isBound());
        Assertions.assertThrows(SocketException.class, () -> serverSocket.bind((SocketAddress)AFUNIXSocketAddress.ofNewTempFile()));
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testServerSocketFactoryMethodsForCodeCoverageOnly(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLServerSocketFactory factory;
        AFUNIXSocketAddress address = AFUNIXSocketAddress.ofNewTempFile();
        try {
            factory = configuration.configure(SSLContextBuilder.forServer()).withKeyStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxserver.p12"), "serverpass"::toCharArray).withSocketFactory((SocketFactory)new AFSocketFactory.FixedAddressSocketFactory((SocketAddress)address)).buildAndDestroyBuilder().getServerSocketFactory();
        }
        catch (KnownJavaBugIOException e) {
            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
        }
        try {
            factory.createServerSocket();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @ParameterizedTest
    @EnumSource(value=SSLTestBase.TestSSLConfiguration.class)
    public void testSSLEngineMethods(SSLTestBase.TestSSLConfiguration configuration) throws Exception {
        SSLContext context;
        try {
            context = configuration.configure(SSLContextBuilder.forServer()).withKeyStore(TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxserver.p12"), "serverpass"::toCharArray).buildAndDestroyBuilder();
        }
        catch (KnownJavaBugIOException e) {
            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
        }
        context.init(null, null, null);
        SSLEngine engine = context.createSSLEngine();
        Assertions.assertNotNull((Object)engine);
        engine = context.createSSLEngine("non-authoritative-name", 123);
        Assertions.assertNotNull((Object)engine);
        context.getClientSessionContext();
        context.getServerSessionContext();
    }

    private /* synthetic */ void lambda$testServerAndClientBlindlyTrustAnything$17(AFUNIXSocketAddress addr, SSLSocketFactory serverSocketFactory, SSLSocketFactory clientSocketFactory, CompletableFuture serverException, CompletableFuture clientException) throws Throwable {
        Exception exception = null;
        try {
            this.runServerAndClient(addr, serverSocketFactory, clientSocketFactory, serverException, clientException, false);
        }
        catch (Exception e) {
            exception = e;
        }
        Assertions.assertNull(serverException.get());
        Assertions.assertNull(clientException.get());
        if (exception != null) {
            throw exception;
        }
    }

    private static /* synthetic */ TrustManager[] lambda$testServerAndClientBlindlyTrustAnything$16(TrustManagerFactory tmf) throws GeneralSecurityException, IOException {
        return new TrustManager[]{IgnorantX509TrustManager.getInstance()};
    }

    private static /* synthetic */ KeyManager[] lambda$testServerAndClientBlindlyTrustAnything$15(KeyManagerFactory kmf) throws GeneralSecurityException, IOException {
        KeyStore ks = SSLContextBuilder.newKeyStorePKCS12();
        try (InputStream in = TestResourceUtil.getRequiredResource(SSLContextBuilderTest.class, (String)"juxserver.p12").openStream();){
            try {
                ks.load(in, "serverpass".toCharArray());
            }
            catch (IOException e) {
                throw SSLContextBuilder.wrapIOExceptionIfJDKBug((IOException)e);
            }
        }
        catch (KnownJavaBugIOException e) {
            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, e.getMessage(), (Throwable)e);
        }
        kmf.init(ks, "serverpass".toCharArray());
        return kmf.getKeyManagers();
    }

    private static /* synthetic */ void lambda$testServerAndClientBlindlyTrustAnything$14(SSLParameters p) {
        p.setNeedClientAuth(true);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class DestroyablePasswordSupplier
    implements SSLSupplier<char[]>,
    Destroyable {
        private char[] password = "serverpass".toCharArray();

        private DestroyablePasswordSupplier() {
        }

        public char[] get() throws GeneralSecurityException, IOException {
            return (char[])this.password.clone();
        }

        @Override
        public void destroy() throws DestroyFailedException {
            Arrays.fill(this.password, ' ');
            this.password = null;
        }

        @Override
        public boolean isDestroyed() {
            return this.password == null;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class UndestroyablePasswordSupplier
    implements SSLSupplier<char[]>,
    Destroyable {
        private final char[] password = "serverpass".toCharArray();

        private UndestroyablePasswordSupplier() {
        }

        public char[] get() throws GeneralSecurityException, IOException {
            return (char[])this.password.clone();
        }
    }
}

