/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
public abstract class EndOfFileTest<A extends SocketAddress>
extends SocketTestBase<A> {
    protected ServerSocket server;
    protected ExecutorService executor;

    protected EndOfFileTest(AddressSpecifics<A> asp) {
        super(asp);
    }

    @BeforeEach
    public void setUp() throws IOException {
        this.server = this.newServerSocket();
        this.bindServerSocket(this.server, this.getServerBindAddress());
        this.executor = Executors.newFixedThreadPool(2);
    }

    @AfterEach
    public void tearDown() throws IOException {
        try {
            if (this.server != null) {
                this.server.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    protected Socket[] connect() throws Exception {
        Socket clientSocket = this.newSocket();
        Future<Socket> serverAcceptFuture = this.executor.submit(new Callable<Socket>(){

            @Override
            public Socket call() throws Exception {
                return EndOfFileTest.this.server.accept();
            }
        });
        Thread.sleep(100L);
        this.connectSocket(clientSocket, this.server.getLocalSocketAddress());
        Socket serverSocket = serverAcceptFuture.get(5L, TimeUnit.SECONDS);
        return new Socket[]{serverSocket, clientSocket};
    }

    @Test
    public void bidirectionalSanity() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            Socket[] sockets = this.connect();
            try (Socket serverSocket = sockets[0];
                 Socket clientSocket = sockets[1];){
                OutputStreamWriter clientOutWriter = new OutputStreamWriter(clientSocket.getOutputStream(), "UTF-8");
                BufferedReader serverInReader = new BufferedReader(new InputStreamReader(serverSocket.getInputStream(), "UTF-8"));
                String input = "TestStringOne";
                clientOutWriter.write(input + "\n");
                clientOutWriter.flush();
                String output = serverInReader.readLine();
                Assertions.assertEquals((Object)input, (Object)output, (String)"Server output should match client input.");
                OutputStreamWriter serverOutWriter = new OutputStreamWriter(serverSocket.getOutputStream(), "UTF-8");
                BufferedReader clientInReader = new BufferedReader(new InputStreamReader(clientSocket.getInputStream(), "UTF-8"));
                input = "TestStringTwo";
                serverOutWriter.write(input + "\n");
                serverOutWriter.flush();
                output = clientInReader.readLine();
                Assertions.assertEquals((Object)input, (Object)output, (String)"Client output should match server input.");
            }
        });
    }

    @Test
    public void serverReadEof() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            Socket[] sockets = this.connect();
            Socket serverSocket = sockets[0];
            Socket clientSocket = sockets[1];
            clientSocket.close();
            Thread.sleep(100L);
            int read = serverSocket.getInputStream().read();
            Assertions.assertEquals((int)-1, (int)read, (String)"Server should see EOF indicated by -1 from read()");
            read = serverSocket.getInputStream().read(new byte[3]);
            Assertions.assertEquals((int)-1, (int)read, (String)"Server should continue to see EOF indicated by -1 from read(...)");
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    @Test
    public void clientReadEof() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            Socket[] sockets = this.connect();
            Socket serverSocket = sockets[0];
            Socket clientSocket = sockets[1];
            serverSocket.close();
            Thread.sleep(100L);
            int read = clientSocket.getInputStream().read();
            Assertions.assertEquals((int)-1, (int)read, (String)"Client should see EOF indicated by -1 from read()");
            read = clientSocket.getInputStream().read(new byte[3]);
            Assertions.assertEquals((int)-1, (int)read, (String)"Client should continue to see EOF indicated by -1 from read(...)");
            try {
                clientSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    @Test
    public void serverWriteToSocketClosedByServer() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            Socket[] sockets = this.connect();
            Socket serverSocket = sockets[0];
            Socket clientSocket = sockets[1];
            serverSocket.close();
            Thread.sleep(100L);
            IOException exception = null;
            try {
                serverSocket.getOutputStream().write(new byte[]{49});
            }
            catch (IOException e) {
                exception = e;
            }
            Assertions.assertNotNull((Object)exception, (String)"Server should see an IOException when writing to a socket that it closed.");
            try {
                clientSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    @Test
    public void serverWriteToSocketClosedByClient() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            Socket[] sockets = this.connect();
            Socket serverSocket = sockets[0];
            Socket clientSocket = sockets[1];
            clientSocket.close();
            Thread.sleep(100L);
            IOException exception = null;
            try {
                serverSocket.getOutputStream().write(new byte[]{49});
                Thread.sleep(100L);
                serverSocket.getOutputStream().write(new byte[]{50});
            }
            catch (IOException e) {
                exception = e;
            }
            Assertions.assertNotNull((Object)exception, (String)"Server should see an IOException when writing to a socket that the client closed.");
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    @Test
    public void clientWriteToSocketClosedByClient() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            Socket[] sockets = this.connect();
            Socket serverSocket = sockets[0];
            Socket clientSocket = sockets[1];
            clientSocket.close();
            Thread.sleep(100L);
            IOException exception = null;
            try {
                clientSocket.getOutputStream().write(new byte[]{49});
            }
            catch (IOException e) {
                exception = e;
            }
            Assertions.assertNotNull((Object)exception, (String)"Client should see an IOException when writing to a socket which it closed.");
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    @Test
    public void clientWriteToSocketClosedByServer() throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(2L), () -> {
            Socket[] sockets = this.connect();
            Socket serverSocket = sockets[0];
            Socket clientSocket = sockets[1];
            serverSocket.close();
            Thread.sleep(100L);
            IOException exception = null;
            try {
                serverSocket.getOutputStream().write(new byte[]{49});
                Thread.sleep(100L);
                serverSocket.getOutputStream().write(new byte[]{50});
            }
            catch (IOException e) {
                exception = e;
            }
            Assertions.assertNotNull((Object)exception, (String)"Client should see an IOException when writing to a socket that the server closed.");
            try {
                clientSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }
}

