/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import java.io.Closeable;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.rmi.NotBoundException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketCredentials;
import org.newsclub.net.unix.rmi.AFUNIXNaming;
import org.newsclub.net.unix.rmi.AFUNIXRMIService;
import org.newsclub.net.unix.rmi.DefaultRMIClientSocketFactory;
import org.newsclub.net.unix.rmi.DefaultRMIServerSocketFactory;
import org.newsclub.net.unix.rmi.RemotePeerInfo;
import org.newsclub.net.unix.rmi.ShutdownException;
import org.newsclub.net.unix.rmi.ShutdownHookSupport;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AFUNIXRMISocketFactory
extends RMISocketFactory
implements Externalizable,
Closeable {
    static final String DEFAULT_SOCKET_FILE_PREFIX = "";
    static final String DEFAULT_SOCKET_FILE_SUFFIX = ".rmi";
    private static final long serialVersionUID = 1L;
    private RMIClientSocketFactory defaultClientFactory;
    private RMIServerSocketFactory defaultServerFactory;
    private File socketDir;
    private AFUNIXNaming naming;
    private String socketPrefix;
    private String socketSuffix;
    private AFUNIXRMIService rmiService = null;
    private final Map<HostAndPort, AFUNIXSocketCredentials> credentials = new HashMap<HostAndPort, AFUNIXSocketCredentials>();
    private final Map<Integer, AFUNIXServerSocket> openServerSockets = new HashMap<Integer, AFUNIXServerSocket>();
    private final Set<AFUNIXSocket> openSockets = new HashSet<AFUNIXSocket>();

    public AFUNIXRMISocketFactory() {
        this.closeUponRuntimeShutdown();
    }

    public AFUNIXRMISocketFactory(AFUNIXNaming naming, File socketDir) throws IOException {
        this(naming, socketDir, DefaultRMIClientSocketFactory.getInstance(), DefaultRMIServerSocketFactory.getInstance());
    }

    public AFUNIXRMISocketFactory(AFUNIXNaming naming, File socketDir, RMIClientSocketFactory defaultClientFactory, RMIServerSocketFactory defaultServerFactory) throws IOException {
        this(naming, socketDir, defaultClientFactory, defaultServerFactory, null, null);
    }

    public AFUNIXRMISocketFactory(AFUNIXNaming naming, File socketDir, RMIClientSocketFactory defaultClientFactory, RMIServerSocketFactory defaultServerFactory, String socketPrefix, String socketSuffix) throws IOException {
        this.naming = naming;
        this.socketDir = socketDir;
        this.defaultClientFactory = defaultClientFactory;
        this.defaultServerFactory = defaultServerFactory;
        this.socketPrefix = socketPrefix == null ? DEFAULT_SOCKET_FILE_PREFIX : socketPrefix;
        this.socketSuffix = socketSuffix == null ? DEFAULT_SOCKET_FILE_SUFFIX : socketSuffix;
        this.closeUponRuntimeShutdown();
    }

    private boolean isPlainFileSocket() {
        return this.naming.getRegistryPort() == Integer.MAX_VALUE;
    }

    private void closeUponRuntimeShutdown() {
        ShutdownHookSupport.addWeakShutdownHook(new ShutdownHookSupport.ShutdownHook(){

            @Override
            public void onRuntimeShutdown(Thread thread) {
                try {
                    AFUNIXRMISocketFactory.this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    public int hashCode() {
        return this.socketDir == null ? super.hashCode() : this.socketDir.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof AFUNIXRMISocketFactory)) {
            return false;
        }
        AFUNIXRMISocketFactory sf = (AFUNIXRMISocketFactory)other;
        return sf.socketDir.equals(this.socketDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket createSocket(String host, int port) throws IOException {
        RMIClientSocketFactory cf = this.defaultClientFactory;
        if (cf != null && port < 100000) {
            return cf.createSocket(host, port);
        }
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.of((File)this.getFile(port), (int)port);
        final AFUNIXSocket socket = AFUNIXSocket.newInstance();
        socket.connect((SocketAddress)addr);
        AFUNIXSocketCredentials creds = socket.getPeerCredentials();
        final HostAndPort hap = new HostAndPort(host, port);
        Object object = this.credentials;
        synchronized (object) {
            if (this.credentials.put(hap, creds) != null) {
                // empty if block
            }
        }
        object = this.openSockets;
        synchronized (object) {
            this.openSockets.add(socket);
        }
        socket.addCloseable(new Closeable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                Object object = AFUNIXRMISocketFactory.this.openSockets;
                synchronized (object) {
                    AFUNIXRMISocketFactory.this.openSockets.remove(socket);
                }
                object = AFUNIXRMISocketFactory.this.credentials;
                synchronized (object) {
                    AFUNIXRMISocketFactory.this.credentials.remove(hap);
                }
            }
        });
        return socket;
    }

    public File getSocketDir() {
        return this.socketDir;
    }

    File getFile(int port) {
        if (this.isPlainFileSocket()) {
            return this.getSocketDir();
        }
        return new File(this.socketDir, this.socketPrefix + port + this.socketSuffix);
    }

    boolean hasSocketFile(int port) {
        return this.getFile(port).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Class<AFUNIXNaming> clazz = AFUNIXNaming.class;
        synchronized (AFUNIXNaming.class) {
            this.credentials.clear();
            this.rmiService = null;
            this.closeServerSockets();
            this.closeSockets();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AFUNIXRMIService getRmiService() throws IOException {
        Class<AFUNIXNaming> clazz = AFUNIXNaming.class;
        synchronized (AFUNIXNaming.class) {
            if (this.rmiService == null) {
                try {
                    this.rmiService = this.naming.getRMIService();
                }
                catch (NotBoundException e) {
                    throw (IOException)new IOException(e.getMessage()).initCause(e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.rmiService;
        }
    }

    protected int newPort() throws IOException {
        return this.getRmiService().newPort();
    }

    protected void returnPort(int port) throws IOException {
        this.getRmiService().returnPort(port);
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        if (port == 0) {
            port = this.newPort();
            AFUNIXSocketAddress addr = AFUNIXSocketAddress.of((File)this.getFile(port), (int)port);
            AnonymousServerSocket ass = new AnonymousServerSocket(port);
            ass.setDeleteOnClose(true);
            ass.bind((SocketAddress)addr);
            if (port >= 100000) {
                ass.addCloseable(new ServerSocketCloseable(ass, port));
            }
            return ass;
        }
        RMIServerSocketFactory sf = this.defaultServerFactory;
        if (sf != null && port < 100000) {
            return sf.createServerSocket(port);
        }
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.of((File)this.getFile(port), (int)port);
        AFUNIXServerSocket socket = AFUNIXServerSocket.newInstance();
        socket.setDeleteOnClose(true);
        socket.setReuseAddress(true);
        socket.bind((SocketAddress)addr);
        socket.addCloseable((Closeable)new ServerSocketCloseable(socket, port));
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeServerSockets() throws IOException {
        HashMap<Integer, AFUNIXServerSocket> map;
        Map<Integer, AFUNIXServerSocket> map2 = this.openServerSockets;
        synchronized (map2) {
            map = new HashMap<Integer, AFUNIXServerSocket>(this.openServerSockets);
        }
        IOException ex = null;
        for (Map.Entry en : map.entrySet()) {
            try {
                ((AFUNIXServerSocket)en.getValue()).close();
            }
            catch (ShutdownException shutdownException) {
            }
            catch (IOException e) {
                if (ex == null) {
                    ex = e;
                    continue;
                }
                ex.addSuppressed(e);
            }
        }
        Map<Integer, AFUNIXServerSocket> map3 = this.openServerSockets;
        synchronized (map3) {
            this.openServerSockets.clear();
        }
        if (ex != null) {
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSockets() {
        HashSet<AFUNIXSocket> set;
        Set<AFUNIXSocket> set2 = this.openSockets;
        synchronized (set2) {
            set = new HashSet<AFUNIXSocket>(this.openSockets);
        }
        for (AFUNIXSocket socket : set) {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
        set2 = this.openSockets;
        synchronized (set2) {
            this.openSockets.clear();
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.socketDir = new File(in.readUTF());
        int port = in.readInt();
        this.naming = AFUNIXNaming.getInstance(this.socketDir, port);
        this.defaultClientFactory = (RMIClientSocketFactory)in.readObject();
        this.defaultServerFactory = (RMIServerSocketFactory)in.readObject();
        this.socketPrefix = in.readUTF();
        this.socketSuffix = in.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.socketDir.getAbsolutePath());
        out.writeInt(this.naming.getRegistryPort());
        out.writeObject(this.defaultClientFactory);
        out.writeObject(this.defaultServerFactory);
        out.writeUTF(this.socketPrefix);
        out.writeUTF(this.socketSuffix);
    }

    public String toString() {
        return super.toString() + "[path=" + this.socketDir + (String)(this.isPlainFileSocket() ? DEFAULT_SOCKET_FILE_PREFIX : ";prefix=" + this.socketPrefix + ";suffix=" + this.socketSuffix) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AFUNIXSocketCredentials peerCredentialsFor(RemotePeerInfo data) {
        Map<HostAndPort, AFUNIXSocketCredentials> map = this.credentials;
        synchronized (map) {
            return this.credentials.get(new HostAndPort(data.host, data.port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocalServer(int port) {
        if (port < 100000) {
            return false;
        }
        Map<Integer, AFUNIXServerSocket> map = this.openServerSockets;
        synchronized (map) {
            return this.openServerSockets.containsKey(port);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class HostAndPort {
        final String hostname;
        final int port;

        private HostAndPort(String hostname, int port) {
            this.hostname = hostname;
            this.port = port;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.hostname == null ? 0 : this.hostname.hashCode());
            result = 31 * result + this.port;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof HostAndPort)) {
                return false;
            }
            HostAndPort other = (HostAndPort)obj;
            if (this.hostname == null ? other.hostname != null : !this.hostname.equals(other.hostname)) {
                return false;
            }
            return this.port == other.port;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private final class AnonymousServerSocket
    extends AFUNIXServerSocket {
        private final int returnPort;

        protected AnonymousServerSocket(int returnPort) throws IOException {
            this.returnPort = returnPort;
            this.setReuseAddress(true);
        }

        public void close() throws IOException {
            super.close();
            AFUNIXRMISocketFactory.this.returnPort(this.returnPort);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private final class ServerSocketCloseable
    implements Closeable {
        private final int port;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ServerSocketCloseable(AFUNIXServerSocket socket, int port) {
            this.port = port;
            Map map = AFUNIXRMISocketFactory.this.openServerSockets;
            synchronized (map) {
                AFUNIXRMISocketFactory.this.openServerSockets.put(port, socket);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Map map = AFUNIXRMISocketFactory.this.openServerSockets;
            synchronized (map) {
                AFUNIXRMISocketFactory.this.openServerSockets.remove(this.port);
            }
        }
    }
}

