/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.rmi.AlreadyBoundException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.Map;
import org.newsclub.net.unix.rmi.AFUNIXNamingRef;
import org.newsclub.net.unix.rmi.AFUNIXRMIService;
import org.newsclub.net.unix.rmi.AFUNIXRMIServiceImpl;
import org.newsclub.net.unix.rmi.AFUNIXRMISocketFactory;
import org.newsclub.net.unix.rmi.AFUNIXRegistry;
import org.newsclub.net.unix.rmi.ShutdownHookSupport;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AFUNIXNaming
implements ShutdownHookSupport.ShutdownHook {
    private static final String RMI_SERVICE_NAME = AFUNIXRMIService.class.getName();
    private static final String PROP_RMI_SOCKET_DIR = "org.newsclub.net.unix.rmi.socketdir";
    private static final File DEFAULT_SOCKET_DIRECTORY = new File(System.getProperty("org.newsclub.net.unix.rmi.socketdir", "/tmp"));
    private static final Map<AFUNIXNamingRef, AFUNIXNaming> INSTANCES = new HashMap<AFUNIXNamingRef, AFUNIXNaming>();
    private AFUNIXRegistry registry = null;
    private AFUNIXRMIService rmiService = null;
    private File registrySocketDir;
    private final int registryPort;
    private final int servicePort;
    private AFUNIXRMISocketFactory socketFactory;
    private boolean deleteRegistrySocketDir = false;
    private boolean remoteShutdownAllowed = true;

    private AFUNIXNaming(File socketDir, int port, String socketPrefix, String socketSuffix) throws IOException {
        this.registrySocketDir = socketDir;
        this.registryPort = port;
        this.servicePort = 100002;
        this.socketFactory = new AFUNIXRMISocketFactory(this, socketDir, null, null, socketPrefix, socketSuffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AFUNIXNaming newPrivateInstance() throws IOException {
        AFUNIXNaming instance;
        File tmpDir = Files.createTempDirectory("junixsocket-", new FileAttribute[0]).toFile();
        if (!tmpDir.canWrite()) {
            throw new IOException("Could not create temporary directory: " + tmpDir);
        }
        AFUNIXNaming aFUNIXNaming = instance = AFUNIXNaming.getInstance(tmpDir, 100001);
        synchronized (aFUNIXNaming) {
            instance.deleteRegistrySocketDir = true;
        }
        return instance;
    }

    public static AFUNIXNaming getInstance() throws IOException {
        return AFUNIXNaming.getInstance(DEFAULT_SOCKET_DIRECTORY, 100001);
    }

    public static AFUNIXNaming getInstance(File socketDir) throws RemoteException {
        return AFUNIXNaming.getInstance(socketDir, 100001);
    }

    public static AFUNIXNaming getInstance(File socketDir, int registryPort) throws RemoteException {
        return AFUNIXNaming.getInstance(socketDir, registryPort, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AFUNIXNaming getInstance(File socketDir, int registryPort, String socketPrefix, String socketSuffix) throws RemoteException {
        if (socketDir == null) {
            socketDir = DEFAULT_SOCKET_DIRECTORY;
            if (!socketDir.mkdirs() && !socketDir.isDirectory()) {
                throw new RemoteException("Cannot create directory for temporary file: " + socketDir);
            }
            if (socketPrefix == null) {
                File tempFile;
                try {
                    tempFile = File.createTempFile("jux", "-", socketDir);
                }
                catch (IOException e) {
                    throw new RemoteException("Cannot create temporary file: " + e.getMessage(), e);
                }
                if (!tempFile.delete()) {
                    tempFile.deleteOnExit();
                }
                socketPrefix = tempFile.getName();
            }
        }
        AFUNIXNamingRef sap = new AFUNIXNamingRef(socketDir, registryPort, socketPrefix, socketSuffix);
        Class<AFUNIXNaming> clazz = AFUNIXNaming.class;
        synchronized (AFUNIXNaming.class) {
            AFUNIXNaming instance = INSTANCES.get(sap);
            if (instance == null) {
                try {
                    instance = new AFUNIXNaming(sap.socketDir, registryPort, socketPrefix, socketSuffix);
                }
                catch (RemoteException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw new RemoteException(e.getMessage(), e);
                }
                INSTANCES.put(sap, instance);
            }
            // ** MonitorExit[var6_7] (shouldn't be in output)
            return instance;
        }
    }

    public static AFUNIXNaming getSingleFileInstance(File socketFile) throws IOException {
        return AFUNIXNaming.getInstance(socketFile, Integer.MAX_VALUE);
    }

    public AFUNIXRMISocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public File getRegistrySocketDir() {
        return this.registrySocketDir;
    }

    public int getRegistryPort() {
        return this.registryPort;
    }

    AFUNIXRMIService getRMIService() throws RemoteException, NotBoundException {
        if (this.rmiService == null) {
            this.rmiService = this.getRMIServiceFromRegistry();
        }
        return this.rmiService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AFUNIXRMIService getRMIServiceFromRegistry() throws RemoteException, NotBoundException {
        Class<AFUNIXRMIService> clazz = AFUNIXRMIService.class;
        synchronized (AFUNIXRMIService.class) {
            AFUNIXRMIService service;
            try {
                service = (AFUNIXRMIService)this.lookup(RMI_SERVICE_NAME);
            }
            catch (MalformedURLException e) {
                throw new RemoteException(e.getMessage(), e);
            }
            return service;
        }
    }

    private void closeUponRuntimeShutdown() {
        ShutdownHookSupport.addWeakShutdownHook(this);
    }

    private void rebindRMIService(AFUNIXRMIService assigner) throws RemoteException {
        this.rmiService = assigner;
        this.getRegistry().rebind(RMI_SERVICE_NAME, assigner);
    }

    public synchronized AFUNIXRegistry getRegistry() throws RemoteException {
        AFUNIXRegistry reg = this.getRegistry(false);
        if (reg == null) {
            throw new RemoteException("Could not find registry at " + this.socketFactory.getFile(this.registryPort));
        }
        return reg;
    }

    public synchronized AFUNIXRegistry getRegistry(boolean create) throws RemoteException {
        if (this.registry != null) {
            return this.registry;
        }
        if (!this.socketFactory.hasSocketFile(this.registryPort)) {
            return create ? this.createRegistry() : null;
        }
        Registry reg = LocateRegistry.getRegistry(null, this.registryPort, this.socketFactory);
        if (reg != null) {
            reg = new AFUNIXRegistry(this, reg);
        }
        this.registry = (AFUNIXRegistry)reg;
        try {
            AFUNIXRMIService service = this.getRMIService();
            this.remoteShutdownAllowed = service.isShutdownAllowed();
        }
        catch (ConnectIOException e) {
            if (create) {
                this.socketFactory.deleteSocketFile(this.registryPort);
                this.registry = null;
                return this.createRegistry();
            }
            throw new ServerException("Could not access " + AFUNIXRMIService.class.getName(), e);
        }
        catch (NotBoundException e) {
            throw new ServerException("Could not access " + AFUNIXRMIService.class.getName(), e);
        }
        return this.registry;
    }

    public Remote lookup(String name) throws NotBoundException, MalformedURLException, RemoteException {
        return this.getRegistry().lookup(name);
    }

    public void unbind(String name) throws RemoteException, NotBoundException, MalformedURLException {
        this.getRegistry().unbind(name);
    }

    public void bind(String name, Remote obj) throws AlreadyBoundException, MalformedURLException, RemoteException {
        this.getRegistry().bind(name, obj);
    }

    public void rebind(String name, Remote obj) throws MalformedURLException, RemoteException {
        this.getRegistry().rebind(name, obj);
    }

    public synchronized void shutdownRegistry() throws RemoteException {
        if (this.registry == null) {
            return;
        }
        AFUNIXRegistry reg = this.registry;
        if (!reg.isRemoteServer()) {
            reg.forceUnexportBound();
            this.shutdownViaRMIService();
            return;
        }
        AFUNIXRMIServiceImpl serviceImpl = (AFUNIXRMIServiceImpl)this.rmiService;
        if (serviceImpl == null) {
            return;
        }
        serviceImpl.shutdownRegisteredCloseables();
        try {
            AFUNIXNaming.unexportObject(this.rmiService);
            this.registry.unbind(RMI_SERVICE_NAME);
        }
        catch (NotBoundException notBoundException) {
            // empty catch block
        }
        reg.forceUnexportBound();
        this.rmiService = null;
        if (this.socketFactory != null) {
            this.socketFactory.deleteSocketFile(this.registryPort);
            this.socketFactory.deleteSocketFile(this.servicePort);
            this.socketFactory.close();
            this.socketFactory = null;
        }
        if (this.deleteRegistrySocketDir && this.registrySocketDir != null) {
            try {
                Files.delete(this.registrySocketDir.toPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.registrySocketDir = null;
        }
    }

    private void shutdownViaRMIService() throws RemoteException {
        AFUNIXRMIService existingAssigner;
        try {
            existingAssigner = this.getRMIServiceFromRegistry();
        }
        catch (ConnectIOException | NotBoundException e) {
            existingAssigner = null;
        }
        if (existingAssigner != null) {
            try {
                existingAssigner.shutdown();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized AFUNIXRegistry createRegistry() throws RemoteException {
        AFUNIXRegistry existingRegistry;
        if (this.registry != null) {
            throw new RemoteException("The Registry is already created: " + this.registry);
        }
        try {
            existingRegistry = this.getRegistry(false);
        }
        catch (ServerException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NotBoundException || cause instanceof ConnectIOException) {
                existingRegistry = null;
            }
            throw e;
        }
        if (existingRegistry != null) {
            if (!this.isRemoteShutdownAllowed()) {
                throw new ServerException("The server refuses to be shutdown remotely");
            }
            this.shutdownViaRMIService();
        }
        this.socketFactory.deleteStaleFiles();
        this.registry = new AFUNIXRegistry(this, LocateRegistry.createRegistry(this.registryPort, this.socketFactory, this.socketFactory));
        AFUNIXRMIServiceImpl service = new AFUNIXRMIServiceImpl(this);
        UnicastRemoteObject.exportObject(service, this.servicePort, this.socketFactory, this.socketFactory);
        this.rebindRMIService(service);
        this.closeUponRuntimeShutdown();
        return this.registry;
    }

    public boolean isRemoteShutdownAllowed() {
        return this.remoteShutdownAllowed;
    }

    public void setRemoteShutdownAllowed(boolean remoteShutdownAllowed) {
        this.remoteShutdownAllowed = remoteShutdownAllowed;
    }

    @Override
    public void onRuntimeShutdown(Thread thread) {
        if (thread != Thread.currentThread() || !(thread instanceof ShutdownHookSupport.ShutdownThread)) {
            throw new IllegalStateException("Illegal caller");
        }
        try {
            this.shutdownRegistry();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void exportAndBind(String name, Remote obj) throws RemoteException, AlreadyBoundException {
        AFUNIXNaming.exportObject(obj, this.getSocketFactory());
        this.getRegistry().bind(name, obj);
    }

    public void exportAndRebind(String name, Remote obj) throws RemoteException {
        AFUNIXNaming.exportObject(obj, this.getSocketFactory());
        this.getRegistry().rebind(name, obj);
    }

    public void unexportAndUnbind(String name, Remote obj) throws RemoteException {
        AFUNIXNaming.unexportObject(obj);
        try {
            this.unbind(name);
        }
        catch (MalformedURLException | NotBoundException exception) {
            // empty catch block
        }
    }

    public static Remote exportObject(Remote obj, RMISocketFactory socketFactory) throws RemoteException {
        return UnicastRemoteObject.exportObject(obj, 0, socketFactory, socketFactory);
    }

    public static void unexportObject(Remote obj) {
        try {
            UnicastRemoteObject.unexportObject(obj, true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }
}

