/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.demo.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.concurrent.Future;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.server.SocketServer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class DemoServerBase
extends SocketServer<SocketAddress, Socket, ServerSocket> {
    public DemoServerBase(SocketAddress listenAddress) {
        super(listenAddress);
    }

    private static String millisToHumanReadable(int millis, String zeroValue) {
        if (millis == 0 && zeroValue != null) {
            return "0 [ms] (" + zeroValue + ")";
        }
        float secs = (float)millis / 1000.0f;
        if (secs - (float)((int)secs) == 0.0f) {
            return millis + " [ms] == " + (int)secs + "s";
        }
        return millis + " [ms] == " + secs + "s";
    }

    protected void onServerStarting() {
        System.out.println();
        System.out.println("Creating server: " + ((Object)((Object)this)).getClass().getName());
        System.out.println("with the following configuration:");
        System.out.println("- maxConcurrentConnections: " + this.getMaxConcurrentConnections());
        System.out.println("- serverTimeout: " + DemoServerBase.millisToHumanReadable(this.getServerTimeout(), "none"));
        System.out.println("- socketTimeout: " + DemoServerBase.millisToHumanReadable(this.getSocketTimeout(), "none"));
        System.out.println("- serverBusyTimeout: " + DemoServerBase.millisToHumanReadable(this.getServerBusyTimeout(), "none"));
    }

    protected void onServerBound(SocketAddress address) {
        System.out.println("Created server -- bound to " + address);
    }

    protected void onServerBusy(long busySince) {
        System.out.println("Server is busy");
    }

    protected void onServerReady(int activeCount) {
        System.out.println("Active connections: " + activeCount + "; waiting for the next connection...");
    }

    protected void onServerStopped(ServerSocket theServerSocket) {
        System.out.println("Close server " + theServerSocket);
    }

    protected void onSubmitted(Socket socket, Future<?> submit) {
        System.out.println("Accepted: " + socket);
    }

    protected void onBeforeServingSocket(Socket socket) {
        System.out.println("Serving socket: " + socket);
        if (socket instanceof AFUNIXSocket) {
            try {
                System.out.println("Client's credentials: " + ((AFUNIXSocket)socket).getPeerCredentials());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void onServerShuttingDown() {
        System.out.println("Nothing going on for a long time, I better stop listening");
    }

    protected void onSocketExceptionDuringAccept(SocketException e) {
        e.printStackTrace();
    }

    protected void onSocketExceptionAfterAccept(Socket socket, SocketException e) {
        System.out.println("Closed (not executed): " + socket);
    }

    protected void onServingException(Socket socket, Throwable t) {
        if (socket.isClosed()) {
            System.out.println("The other end disconnected (" + t.getMessage() + "): " + socket);
            return;
        }
        System.err.println("Exception thrown in " + socket + ", connected: " + socket.isConnected() + ", " + socket.isBound() + "," + socket.isClosed() + "," + socket.isInputShutdown() + "," + socket.isOutputShutdown());
        t.printStackTrace();
    }

    protected void onAfterServingSocket(Socket socket) {
        System.out.println("Closed: " + socket);
    }

    protected void onListenException(Exception e) {
        e.printStackTrace();
    }

    protected ServerSocket newServerSocket() throws IOException {
        SocketAddress listenAddress = this.getListenAddress();
        if (listenAddress instanceof AFSocketAddress) {
            return ((AFSocketAddress)listenAddress).getAddressFamily().newServerSocket();
        }
        return new ServerSocket();
    }
}

