/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.demo.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.io.File;
import java.net.SocketAddress;
import java.nio.channels.spi.SelectorProvider;
import java.util.concurrent.Executor;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFUNIXSelectorProvider;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.demo.netty.EchoServerHandler;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class EchoServer {
    private final AFSocketAddress addr;

    public EchoServer(AFSocketAddress addr) {
        this.addr = addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        AFUNIXSelectorProvider provider = AFUNIXSelectorProvider.provider();
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(0, (Executor)null, (SelectorProvider)provider);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(0, (Executor)null, (SelectorProvider)provider);
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channelFactory(() -> EchoServer.lambda$run$0((SelectorProvider)provider))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new EchoServerHandler()});
                }
            }).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            ChannelFuture f = b.bind((SocketAddress)this.addr).sync();
            f.channel().closeFuture().sync();
        }
        finally {
            workerGroup.shutdownGracefully();
            bossGroup.shutdownGracefully();
        }
    }

    public static void main(String[] args) throws Exception {
        File path = new File("/tmp/nettyecho");
        if (args.length > 0) {
            path = new File(args[0]);
        }
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.of((File)path);
        System.out.println("Binding to " + String.valueOf(addr));
        new EchoServer((AFSocketAddress)addr).run();
    }

    private static /* synthetic */ ServerChannel lambda$run$0(SelectorProvider provider) {
        return new NioServerSocketChannel(provider);
    }
}

