/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.demo.okhttp;

import com.kohlschutter.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.NoRouteToHostException;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.newsclub.net.unix.AFSocketFactory;
import org.newsclub.net.unix.AFTIPCSocketAddress;
import org.newsclub.net.unix.demo.DemoHelper;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class OkHttpClientTIPCDemo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, InterruptedException {
        SocketAddress addr = DemoHelper.parseAddress(args, (SocketAddress)AFTIPCSocketAddress.ofService((int)8080, (int)1));
        OkHttpClient client = new OkHttpClient.Builder().socketFactory((SocketFactory)new AFSocketFactory.FixedAddressSocketFactory(addr)).retryOnConnectionFailure(true).connectTimeout(500L, TimeUnit.MILLISECONDS).readTimeout(500L, TimeUnit.MILLISECONDS).callTimeout(500L, TimeUnit.MILLISECONDS).build();
        while (!Thread.interrupted()) {
            block18: {
                Request request = new Request.Builder().url("http://localhost/").build();
                try (Response response = client.newCall(request).execute();){
                    ResponseBody body = response.body();
                    if (body == null) break block18;
                    try (InputStream in = body.byteStream();){
                        IOUtil.transferAllBytes((InputStream)in, (OutputStream)System.out);
                    }
                    finally {
                        body.close();
                    }
                }
                catch (InterruptedIOException | NoRouteToHostException e) {
                    e.printStackTrace();
                }
            }
            client.connectionPool().evictAll();
            Thread.sleep(100L);
        }
    }
}

