/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.demo.rmi.fd;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.rmi.RemoteException;
import java.rmi.server.RMISocketFactory;
import org.newsclub.net.unix.demo.rmi.services.StreamService;
import org.newsclub.net.unix.rmi.AFUNIXRMISocketFactory;
import org.newsclub.net.unix.rmi.RemoteCloseableImpl;
import org.newsclub.net.unix.rmi.RemoteFileInput;
import org.newsclub.net.unix.rmi.RemoteFileOutput;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class StreamServiceImpl
implements StreamService,
Closeable {
    private final AFUNIXRMISocketFactory socketFactory;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public StreamServiceImpl(AFUNIXRMISocketFactory socketFactory) throws RemoteException {
        this.socketFactory = socketFactory;
    }

    @Override
    public void close() throws IOException {
    }

    public RemoteCloseableImpl<RemoteFileInput> openForReading(File path) throws IOException {
        boolean permitted = this.mayRead(path);
        System.out.println("Reading from " + String.valueOf(path) + "; permitted=" + permitted);
        if (!permitted) {
            throw new AccessDeniedException("Not permitted");
        }
        FileInputStream fin = new FileInputStream(path);
        return new RemoteCloseableImpl((RMISocketFactory)this.socketFactory, (Object)new RemoteFileInput(this.socketFactory, fin));
    }

    public RemoteCloseableImpl<RemoteFileOutput> openForWriting(File path) throws IOException {
        boolean permitted = this.mayWrite(path);
        System.out.println("Writing to " + String.valueOf(path) + "; permitted=" + permitted);
        if (!permitted) {
            throw new AccessDeniedException("Not permitted");
        }
        FileOutputStream fout = new FileOutputStream(path);
        return new RemoteCloseableImpl((RMISocketFactory)this.socketFactory, (Object)new RemoteFileOutput(this.socketFactory, fout));
    }

    protected boolean mayRead(File path) {
        return true;
    }

    protected boolean mayWrite(File path) {
        return true;
    }
}

