/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.demo.okhttp;

import com.kohlschutter.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.time.Duration;
import javax.net.SocketFactory;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.newsclub.net.unix.AFSocketFactory;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.demo.DemoHelper;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class OkHttpClientDemo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        block15: {
            SocketAddress addr = DemoHelper.parseAddress(args, (SocketAddress)AFUNIXSocketAddress.of((File)new File("/tmp/junixsocket-http-server.sock")));
            OkHttpClient.Builder builder = new OkHttpClient.Builder().socketFactory((SocketFactory)new AFSocketFactory.FixedAddressSocketFactory(addr)).callTimeout(Duration.ofMinutes(1L));
            OkHttpClient client = builder.build();
            Request request = new Request.Builder().url("http://localhost/").build();
            try (Response response = client.newCall(request).execute();){
                ResponseBody body = response.body();
                if (body == null) break block15;
                try (InputStream in = body.byteStream();){
                    IOUtil.transferAllBytes((InputStream)in, (OutputStream)System.out);
                }
                finally {
                    body.close();
                }
            }
        }
    }
}

