/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.demo;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketAddress;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class SimpleTestServer {
    private static final int MAX_NUMBER = 5;

    private SimpleTestServer() {
        throw new UnsupportedOperationException("No instances");
    }

    public static void main(String[] args) throws IOException {
        File socketFile = new File(new File(System.getProperty("java.io.tmpdir")), "junixsocket-test.sock");
        System.out.println(socketFile);
        try (AFUNIXServerSocket server = AFUNIXServerSocket.newInstance();){
            server.bind((SocketAddress)AFUNIXSocketAddress.of((File)socketFile));
            System.out.println("server: " + server);
            block24: while (!Thread.interrupted()) {
                System.out.println("Waiting for connection...");
                try {
                    AFUNIXSocket sock = server.accept();
                    try {
                        System.out.println("Connected: " + sock);
                        InputStream is = sock.getInputStream();
                        try {
                            OutputStream os = sock.getOutputStream();
                            try {
                                System.out.println("Saying hello to client " + os);
                                os.write("Hello, dear Client".getBytes("UTF-8"));
                                os.flush();
                                byte[] buf = new byte[128];
                                int read = is.read(buf);
                                System.out.println("Client's response: " + new String(buf, 0, read, "UTF-8"));
                                System.out.println("Now counting to 5...");
                                DataOutputStream dout = new DataOutputStream(os);
                                DataInputStream din = new DataInputStream(is);
                                int number = 0;
                                while (!Thread.interrupted()) {
                                    System.out.println("write " + ++number);
                                    dout.writeInt(number);
                                    try {
                                        Thread.sleep(1000L);
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                        continue block24;
                                    }
                                    if (number > 5) {
                                        System.out.println("write -123 (end of numbers)");
                                        dout.writeInt(-123);
                                        continue block24;
                                    }
                                    int theirNumber = din.readInt();
                                    System.out.println("received " + theirNumber);
                                    if (theirNumber == number * 2) continue;
                                    throw new IllegalStateException("Received the wrong number: " + theirNumber);
                                }
                            }
                            finally {
                                if (os == null) continue;
                                os.close();
                            }
                        }
                        finally {
                            if (is == null) continue;
                            is.close();
                        }
                    }
                    finally {
                        if (sock == null) continue;
                        sock.close();
                    }
                }
                catch (IOException e) {
                    if (server.isClosed()) {
                        throw e;
                    }
                    e.printStackTrace();
                }
            }
        }
    }
}

