/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.demo;

import com.kohlschutter.annotations.compiletime.ExcludeFromCodeCoverageGeneratedReport;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class DemoHelper {
    @ExcludeFromCodeCoverageGeneratedReport
    private DemoHelper() {
        throw new IllegalStateException("No instances");
    }

    public static void addProperty(Properties props, String key, String defaultValue, String property, String exampleValue) {
        String value = defaultValue;
        if (property == null) {
            System.out.println(key + "=" + value);
        } else {
            value = System.getProperty(property, value);
            String example = exampleValue == null ? "" : (exampleValue.endsWith(")") ? "=" + exampleValue : "=" + exampleValue + " (for example)");
            System.out.println(key + "=" + value + " -- override with -D" + property + example);
        }
        props.setProperty(key, value);
    }

    public static void initJDBCDriverClass(String property, String defaultValue, String exampleValue) throws ClassNotFoundException {
        if (exampleValue == null) {
            exampleValue = "(...)";
        } else if (!exampleValue.endsWith(")")) {
            exampleValue = exampleValue + " (for example)";
        }
        String driverClass = System.getProperty(property, defaultValue);
        if (driverClass.isEmpty()) {
            System.out.println("Using JDBC driver provided by SPI -- override with -D" + property + "=" + exampleValue);
        } else {
            if (driverClass.equals(defaultValue)) {
                System.out.println("Using JDBC default driver " + driverClass + " -- override with -D" + property + "=" + exampleValue);
            } else {
                System.out.println("Using JDBC driver provided by -D" + property + "=" + driverClass);
            }
            Class.forName(driverClass);
        }
    }

    public static String getPropertyValue(String property, String defaultValue, String exampleValue) {
        return (String)DemoHelper.getPropertyValue(property, property, defaultValue, exampleValue, null);
    }

    public static <R> R getPropertyValue(String property, String defaultValue, String exampleValue, Function<String, R> valueConverter) {
        return DemoHelper.getPropertyValue(property, property, defaultValue, exampleValue, valueConverter);
    }

    public static <R> R getPropertyValue(String variable, String property, String defaultValue, String exampleValue, Function<String, R> valueConverter) {
        boolean print = true;
        if (exampleValue == null) {
            print = false;
        } else if (exampleValue.isEmpty()) {
            exampleValue = "(...)";
        } else {
            if (exampleValue.contains("$")) {
                exampleValue = "'" + exampleValue + "'";
            }
            if (!exampleValue.endsWith(")")) {
                exampleValue = exampleValue + " (for example)";
            }
        }
        String value = System.getProperty(property, defaultValue);
        if (print) {
            String overrideOrSet;
            String valueString;
            if (value == null) {
                valueString = "(not set)";
                overrideOrSet = "set";
            } else {
                valueString = value;
                overrideOrSet = "override";
            }
            if (Objects.equals(defaultValue, exampleValue)) {
                System.out.println(variable + "=" + valueString + " -- " + overrideOrSet + " with -D" + property + "=(...)");
            } else {
                System.out.println(variable + "=" + valueString + " -- " + overrideOrSet + " with -D" + property + "=" + exampleValue);
            }
        }
        String returnValue = valueConverter != null ? valueConverter.apply(value) : value;
        return (R)returnValue;
    }

    public static SocketAddress socketAddress(String socketName) throws IOException {
        int colon = socketName.lastIndexOf(58);
        int slashOrBackslash = Math.max(socketName.lastIndexOf(47), socketName.lastIndexOf(92));
        if (socketName.startsWith("@")) {
            return AFUNIXSocketAddress.inAbstractNamespace((String)socketName.substring(1));
        }
        if (colon > 0 && slashOrBackslash < colon && !socketName.startsWith("/")) {
            String hostname = socketName.substring(0, colon);
            int port = Integer.parseInt(socketName.substring(colon + 1));
            return new InetSocketAddress(hostname, port);
        }
        return AFUNIXSocketAddress.of((File)new File(socketName));
    }

    public static Socket connectSocket(SocketAddress socketAddress) throws IOException {
        if (socketAddress instanceof AFUNIXSocketAddress) {
            return AFUNIXSocket.connectTo((AFUNIXSocketAddress)((AFUNIXSocketAddress)socketAddress));
        }
        Socket socket = new Socket();
        socket.connect(socketAddress);
        return socket;
    }
}

