/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.demo;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import org.newsclub.net.unix.AFInputStream;
import org.newsclub.net.unix.AFOutputStream;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.SocketClosedException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class SimpleTestServer {
    private static final int MAX_NUMBER = 5;

    private SimpleTestServer() {
        throw new UnsupportedOperationException("No instances");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        File socketFile = new File(new File(System.getProperty("java.io.tmpdir")), "junixsocket-test.sock");
        System.out.println(socketFile);
        try (AFUNIXServerSocket server = AFUNIXServerSocket.newInstance();){
            server.bind((SocketAddress)AFUNIXSocketAddress.of((File)socketFile));
            System.out.println("server: " + server);
            block43: while (!Thread.interrupted() && !server.isClosed()) {
                System.out.println("Waiting for connection...");
                boolean remoteReady = false;
                try {
                    AFUNIXSocket sock = server.accept();
                    try {
                        AFInputStream is = sock.getInputStream();
                        try {
                            AFOutputStream os = sock.getOutputStream();
                            try (DataOutputStream dout = new DataOutputStream((OutputStream)os);
                                 DataInputStream din = new DataInputStream((InputStream)is);){
                                remoteReady = true;
                                System.out.println("Connected: " + sock);
                                if (sock.checkConnectionClosed()) {
                                    System.out.println("Peer closed socket right after connecting");
                                    continue;
                                }
                                System.out.println("Saying hello to client " + sock);
                                os.write("Hello, dear Client".getBytes(StandardCharsets.UTF_8));
                                os.flush();
                                byte[] buf = new byte[128];
                                int read = is.read(buf);
                                System.out.println("Client's response: " + new String(buf, 0, read, "UTF-8"));
                                System.out.println("Now counting to 5...");
                                int number = 0;
                                while (!Thread.interrupted()) {
                                    System.out.println("write " + ++number);
                                    dout.writeInt(number);
                                    try {
                                        Thread.sleep(1000L);
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                        continue block43;
                                    }
                                    if (number >= 5) {
                                        System.out.println("write -123 (end of numbers)");
                                        dout.writeInt(-123);
                                        continue block43;
                                    }
                                    int theirNumber = din.readInt();
                                    System.out.println("received " + theirNumber);
                                    if (theirNumber == number * 2) continue;
                                    throw new IllegalStateException("Received the wrong number: " + theirNumber);
                                }
                            }
                            finally {
                                if (os == null) continue;
                                os.close();
                            }
                        }
                        finally {
                            if (is == null) continue;
                            is.close();
                        }
                    }
                    finally {
                        if (sock == null) continue;
                        sock.close();
                    }
                }
                catch (SocketClosedException e) {
                    if (!remoteReady) continue;
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            System.out.println("Server terminated");
        }
    }
}

