/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.demo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.net.SocketException;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SimpleTestClient {
    public static void main(String[] args) throws IOException {
        File socketFile = new File(new File(System.getProperty("java.io.tmpdir")), "junixsocket-test.sock");
        try (AFUNIXSocket sock = AFUNIXSocket.newInstance();){
            try {
                sock.connect((SocketAddress)new AFUNIXSocketAddress(socketFile));
            }
            catch (SocketException e) {
                System.out.println("Cannot connect to server. Have you started it?");
                System.out.println();
                throw e;
            }
            System.out.println("Connected");
            try (InputStream is = sock.getInputStream();
                 OutputStream os = sock.getOutputStream();){
                byte[] buf = new byte[128];
                int read = is.read(buf);
                System.out.println("Server says: " + new String(buf, 0, read, "UTF-8"));
                System.out.println("Replying to server...");
                os.write("Hello Server".getBytes("UTF-8"));
                os.flush();
            }
        }
        System.out.println("End of communication.");
    }
}

