/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.NativeUnixSocket;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class AFUNIXSocketImpl
extends SocketImpl {
    private static final int SHUT_RD = 0;
    private static final int SHUT_WR = 1;
    private static final int SHUT_RD_WR = 2;
    private String socketFile;
    private boolean closed = false;
    private boolean bound = false;
    private boolean connected = false;
    private volatile boolean closedInputStream = false;
    private volatile boolean closedOutputStream = false;
    private final AFUNIXInputStream in = new AFUNIXInputStream();
    private final AFUNIXOutputStream out = new AFUNIXOutputStream();

    protected AFUNIXSocketImpl() {
        this.fd = new FileDescriptor();
    }

    FileDescriptor getFD() {
        return this.fd;
    }

    protected final void finalize() {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected void accept(SocketImpl socket) throws IOException {
        FileDescriptor fdesc = this.validFdOrException();
        AFUNIXSocketImpl si = (AFUNIXSocketImpl)socket;
        NativeUnixSocket.accept(this.socketFile, fdesc, si.fd);
        si.socketFile = this.socketFile;
        si.connected = true;
    }

    @Override
    protected int available() throws IOException {
        FileDescriptor fdesc = this.validFdOrException();
        return NativeUnixSocket.available(fdesc);
    }

    protected void bind(SocketAddress addr) throws IOException {
        this.bind(0, addr);
    }

    protected void bind(int backlog, SocketAddress addr) throws IOException {
        if (!(addr instanceof AFUNIXSocketAddress)) {
            throw new SocketException("Cannot bind to this type of address: " + addr.getClass());
        }
        AFUNIXSocketAddress socketAddress = (AFUNIXSocketAddress)addr;
        this.socketFile = socketAddress.getSocketFile();
        NativeUnixSocket.bind(this.socketFile, this.fd, backlog);
        this.validFdOrException();
        this.bound = true;
        this.localport = socketAddress.getPort();
    }

    @Override
    protected void bind(InetAddress host, int port) throws IOException {
        throw new SocketException("Cannot bind to this type of address: " + InetAddress.class);
    }

    private void checkClose() throws IOException {
        if (!this.closedInputStream || this.closedOutputStream) {
            // empty if block
        }
    }

    @Override
    protected final synchronized void close() throws IOException {
        FileDescriptor fdesc = this.validFd();
        if (fdesc != null) {
            NativeUnixSocket.shutdown(fdesc, 2);
            NativeUnixSocket.close(fdesc);
        }
        if (this.bound) {
            NativeUnixSocket.unlink(this.socketFile);
        }
        this.connected = false;
        this.closed = true;
    }

    @Override
    protected void connect(String host, int port) throws IOException {
        throw new SocketException("Cannot bind to this type of address: " + InetAddress.class);
    }

    @Override
    protected void connect(InetAddress address, int port) throws IOException {
        throw new SocketException("Cannot bind to this type of address: " + InetAddress.class);
    }

    @Override
    protected void connect(SocketAddress addr, int timeout) throws IOException {
        if (!(addr instanceof AFUNIXSocketAddress)) {
            throw new SocketException("Cannot bind to this type of address: " + addr.getClass());
        }
        AFUNIXSocketAddress socketAddress = (AFUNIXSocketAddress)addr;
        this.socketFile = socketAddress.getSocketFile();
        NativeUnixSocket.connect(this.validateSocketFile(this.socketFile), this.fd);
        this.validFdOrException();
        this.address = socketAddress.getAddress();
        this.port = socketAddress.getPort();
        this.localport = 0;
        this.connected = true;
    }

    private String validateSocketFile(String file) throws SocketException {
        if (!new File(file).exists()) {
            throw new SocketException("Socket file not found: " + this.socketFile);
        }
        return file;
    }

    @Override
    protected void create(boolean stream) throws IOException {
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        if (!this.connected && !this.bound) {
            throw new IOException("Not connected/not bound");
        }
        this.validFdOrException();
        return this.in;
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        if (!this.connected && !this.bound) {
            throw new IOException("Not connected/not bound");
        }
        this.validFdOrException();
        return this.out;
    }

    @Override
    protected void listen(int backlog) throws IOException {
        FileDescriptor fdesc = this.validFdOrException();
        NativeUnixSocket.listen(fdesc, backlog);
    }

    @Override
    protected void sendUrgentData(int data) throws IOException {
        FileDescriptor fdesc = this.validFdOrException();
        NativeUnixSocket.write(fdesc, new byte[]{(byte)(data & 0xFF)}, 0, 1);
    }

    private FileDescriptor validFdOrException() throws SocketException {
        FileDescriptor fdesc = this.validFd();
        if (fdesc == null) {
            throw new SocketException("Not open");
        }
        return fdesc;
    }

    private synchronized FileDescriptor validFd() {
        if (this.closed) {
            return null;
        }
        FileDescriptor descriptor = this.fd;
        if (descriptor != null && descriptor.valid()) {
            return descriptor;
        }
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + "[fd=" + this.fd + "; file=" + this.socketFile + "; connected=" + this.connected + "; bound=" + this.bound + "]";
    }

    private static int expectInteger(Object value) throws SocketException {
        try {
            return (Integer)value;
        }
        catch (ClassCastException e) {
            throw (SocketException)new SocketException("Unsupported value: " + value).initCause(e);
        }
        catch (NullPointerException e) {
            throw (SocketException)new SocketException("Value must not be null").initCause(e);
        }
    }

    private static int expectBoolean(Object value) throws SocketException {
        try {
            return (Boolean)value != false ? 1 : 0;
        }
        catch (ClassCastException e) {
            throw (SocketException)new SocketException("Unsupported value: " + value).initCause(e);
        }
        catch (NullPointerException e) {
            throw (SocketException)new SocketException("Value must not be null").initCause(e);
        }
    }

    @Override
    public Object getOption(int optID) throws SocketException {
        FileDescriptor fdesc = this.validFdOrException();
        try {
            switch (optID) {
                case 1: 
                case 8: {
                    return NativeUnixSocket.getSocketOptionInt(fdesc, optID) != 0;
                }
                case 128: 
                case 4097: 
                case 4098: 
                case 4102: {
                    return NativeUnixSocket.getSocketOptionInt(fdesc, optID);
                }
            }
            throw new SocketException("Unsupported option: " + optID);
        }
        catch (SocketException e) {
            throw e;
        }
        catch (Exception e) {
            throw (SocketException)new SocketException("Error while getting option").initCause(e);
        }
    }

    @Override
    public void setOption(int optID, Object value) throws SocketException {
        FileDescriptor fdesc = this.validFdOrException();
        try {
            switch (optID) {
                case 128: {
                    if (value instanceof Boolean) {
                        boolean b = (Boolean)value;
                        if (b) {
                            throw new SocketException("Only accepting Boolean.FALSE here");
                        }
                        NativeUnixSocket.setSocketOptionInt(fdesc, optID, -1);
                        return;
                    }
                    NativeUnixSocket.setSocketOptionInt(fdesc, optID, AFUNIXSocketImpl.expectInteger(value));
                    return;
                }
                case 4097: 
                case 4098: 
                case 4102: {
                    NativeUnixSocket.setSocketOptionInt(fdesc, optID, AFUNIXSocketImpl.expectInteger(value));
                    return;
                }
                case 1: 
                case 8: {
                    NativeUnixSocket.setSocketOptionInt(fdesc, optID, AFUNIXSocketImpl.expectBoolean(value));
                    return;
                }
            }
            throw new SocketException("Unsupported option: " + optID);
        }
        catch (SocketException e) {
            throw e;
        }
        catch (Exception e) {
            throw (SocketException)new SocketException("Error while setting option").initCause(e);
        }
    }

    @Override
    protected void shutdownInput() throws IOException {
        FileDescriptor fdesc = this.validFd();
        if (fdesc != null) {
            NativeUnixSocket.shutdown(fdesc, 0);
        }
    }

    @Override
    protected void shutdownOutput() throws IOException {
        FileDescriptor fdesc = this.validFd();
        if (fdesc != null) {
            NativeUnixSocket.shutdown(fdesc, 1);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class Lenient
    extends AFUNIXSocketImpl {
        Lenient() {
        }

        @Override
        public void setOption(int optID, Object value) throws SocketException {
            try {
                super.setOption(optID, value);
            }
            catch (SocketException e) {
                switch (optID) {
                    case 1: {
                        return;
                    }
                }
                throw e;
            }
        }

        @Override
        public Object getOption(int optID) throws SocketException {
            try {
                return super.getOption(optID);
            }
            catch (SocketException e) {
                switch (optID) {
                    case 1: 
                    case 8: {
                        return false;
                    }
                }
                throw e;
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private final class AFUNIXOutputStream
    extends OutputStream {
        private volatile boolean streamClosed = false;

        private AFUNIXOutputStream() {
        }

        @Override
        public void write(int oneByte) throws IOException {
            byte[] buf1 = new byte[]{(byte)oneByte};
            this.write(buf1, 0, 1);
        }

        @Override
        public void write(byte[] buf, int off, int len) throws IOException {
            if (this.streamClosed) {
                throw new SocketException("This OutputStream has already been closed.");
            }
            if (len < 0 || off < 0 || len > buf.length - off) {
                throw new IndexOutOfBoundsException();
            }
            FileDescriptor fdesc = AFUNIXSocketImpl.this.validFdOrException();
            int writtenTotal = 0;
            try {
                while (len > 0) {
                    if (Thread.interrupted()) {
                        InterruptedIOException ex = new InterruptedIOException("Thread interrupted during write");
                        ex.bytesTransferred = writtenTotal;
                        Thread.currentThread().interrupt();
                        throw ex;
                    }
                    int written = NativeUnixSocket.write(fdesc, buf, off, len);
                    if (written < 0) {
                        throw new IOException("Unspecific error while writing");
                    }
                    len -= written;
                    off += written;
                    writtenTotal += written;
                }
            }
            catch (IOException e) {
                throw (IOException)new IOException(e.getMessage() + " at " + AFUNIXSocketImpl.this.toString()).initCause(e);
            }
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.streamClosed) {
                return;
            }
            this.streamClosed = true;
            FileDescriptor fdesc = AFUNIXSocketImpl.this.validFd();
            if (fdesc != null) {
                NativeUnixSocket.shutdown(fdesc, 1);
            }
            AFUNIXSocketImpl.this.closedOutputStream = true;
            AFUNIXSocketImpl.this.checkClose();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private final class AFUNIXInputStream
    extends InputStream {
        private volatile boolean streamClosed = false;

        private AFUNIXInputStream() {
        }

        @Override
        public int read(byte[] buf, int off, int len) throws IOException {
            if (this.streamClosed) {
                throw new IOException("This InputStream has already been closed.");
            }
            FileDescriptor fdesc = AFUNIXSocketImpl.this.validFdOrException();
            if (len == 0) {
                return 0;
            }
            if (off < 0 || len < 0 || len > buf.length - off) {
                throw new IndexOutOfBoundsException();
            }
            try {
                return NativeUnixSocket.read(fdesc, buf, off, len);
            }
            catch (IOException e) {
                throw (IOException)new IOException(e.getMessage() + " at " + AFUNIXSocketImpl.this.toString()).initCause(e);
            }
        }

        @Override
        public int read() throws IOException {
            byte[] buf1 = new byte[1];
            int numRead = this.read(buf1, 0, 1);
            if (numRead <= 0) {
                return -1;
            }
            return buf1[0] & 0xFF;
        }

        @Override
        public synchronized void close() throws IOException {
            this.streamClosed = true;
            FileDescriptor fdesc = AFUNIXSocketImpl.this.validFd();
            if (fdesc != null) {
                NativeUnixSocket.shutdown(fdesc, 0);
            }
            AFUNIXSocketImpl.this.closedInputStream = true;
            AFUNIXSocketImpl.this.checkClose();
        }

        @Override
        public int available() throws IOException {
            if (this.streamClosed) {
                throw new IOException("This InputStream has already been closed.");
            }
            FileDescriptor fdesc = AFUNIXSocketImpl.this.validFdOrException();
            return NativeUnixSocket.available(fdesc);
        }
    }
}

