/*
 * Decompiled with CFR 0.152.
 */
package com.knappsack.swagger4springweb.parser;

import com.knappsack.swagger4springweb.util.ModelUtils;
import com.wordnik.swagger.core.ApiValues;
import com.wordnik.swagger.model.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.Option;

public class ApiPathParser {
    private static final Pattern PATTERN = Pattern.compile("\\{([a-zA-Z]+)\\}");
    private static final Class<?> TYPE = String.class;

    public List<Parameter> getPathParameters(String resourcePath, String[] methodPaths) {
        HashMap<String, Parameter> parameters = new HashMap<String, Parameter>();
        this.addParameters(parameters, resourcePath);
        if (methodPaths != null) {
            for (String methodPath : methodPaths) {
                this.addParameters(parameters, methodPath);
            }
        }
        return new ArrayList<Parameter>(parameters.values());
    }

    private void addParameters(Map<String, Parameter> parameters, String path) {
        for (String parameter : this.getPathParameters(path)) {
            parameters.put(parameter, this.createParameter(parameter));
        }
    }

    private Parameter createParameter(String parameter) {
        Option descriptionOption = Option.apply((Object)this.getDescription(parameter));
        return new Parameter(parameter, descriptionOption, null, true, ModelUtils.isAllowMultiple(TYPE), ModelUtils.getSwaggerTypeFor(TYPE), null, ApiValues.TYPE_PATH(), null);
    }

    private String getDescription(String parameter) {
        StringBuilder builder = new StringBuilder();
        if (parameter == null || parameter.length() < 3) {
            return parameter;
        }
        String tmp = parameter;
        for (int i = 0; i < tmp.length(); ++i) {
            if (!Character.isUpperCase(tmp.charAt(i))) continue;
            if (builder.length() == 0) {
                builder.append(tmp.substring(0, 1).toUpperCase()).append(tmp.substring(1, i));
            } else {
                builder.append(tmp.substring(0, i).toLowerCase());
            }
            builder.append(" ");
            tmp = tmp.substring(i);
            i = 0;
        }
        return builder.append(tmp.toLowerCase()).toString();
    }

    private List<String> getPathParameters(String path) {
        ArrayList<String> parameters = new ArrayList<String>();
        if (path == null || path.trim().length() == 0) {
            return Collections.emptyList();
        }
        Matcher matcher = PATTERN.matcher(path);
        while (matcher.find()) {
            parameters.add(matcher.group(1));
        }
        return parameters;
    }
}

