/*
 * Decompiled with CFR 0.152.
 */
package com.knappsack.swagger4springweb.parser;

import com.knappsack.swagger4springweb.util.ModelUtils;
import com.wordnik.swagger.model.Model;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

public class ApiModelParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiModelParser.class);
    private final Map<String, Model> models;

    public ApiModelParser(Map<String, Model> models) {
        this.models = models;
    }

    public void parseResponseBodyModels(Method method) {
        boolean isRestController = false;
        try {
            isRestController = method.getDeclaringClass().getAnnotation(RestController.class) != null;
        }
        catch (NoClassDefFoundError e) {
            LOGGER.debug("No RestController found.  RestController is found in Spring 4.  This is potentially an earlier version of Spring", (Throwable)e);
        }
        if (method.getAnnotation(ResponseBody.class) != null || isRestController) {
            Type type = method.getGenericReturnType();
            ModelUtils.addModels(type, this.models);
        }
    }
}

