/*
 * Decompiled with CFR 0.152.
 */
package com.knappsack.swagger4springweb.controller;

import com.knappsack.swagger4springweb.filter.Filter;
import com.knappsack.swagger4springweb.parser.ApiParserImpl;
import com.wordnik.swagger.model.ApiInfo;
import com.wordnik.swagger.model.ApiListing;
import com.wordnik.swagger.model.ResourceListing;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.HandlerMapping;

@Controller
@RequestMapping(value={"/api"})
public class ApiDocumentationController {
    private String baseControllerPackage = "";
    private List<String> additionalControllerPackages = new ArrayList<String>();
    private String baseModelPackage = "";
    private List<String> additionalModelPackages = new ArrayList<String>();
    private String basePath = "";
    private String apiVersion = "v1";
    private Map<String, ApiListing> documentation;
    private List<String> ignorableAnnotations = new ArrayList<String>();
    private boolean ignoreUnusedPathVariables = true;
    private boolean basePathFromReferer = false;
    private ResourceListing resourceList;
    private ApiInfo apiInfo;
    private List<Filter> filters;

    @RequestMapping(value={"/resourceList"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ResourceListing getResources(HttpServletRequest request) {
        return this.getResourceList(request);
    }

    @RequestMapping(value={"/resourceList/doc/**"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiListing getDocumentation(HttpServletRequest request) {
        String handlerMappingPath = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        handlerMappingPath = handlerMappingPath.substring(handlerMappingPath.lastIndexOf("/doc") + 4, handlerMappingPath.length());
        Map<String, ApiListing> docs = this.getDocs(request);
        if (docs == null) {
            return null;
        }
        return docs.get(handlerMappingPath);
    }

    public String getBasePath() {
        HttpServletRequest request;
        if ((this.basePath == null || this.basePath.isEmpty()) && (request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest()) != null) {
            String referer = request.getHeader("Referer");
            if (this.basePathFromReferer && referer != null) {
                this.basePath = referer.substring(0, referer.lastIndexOf("/"));
            } else {
                String mapping = request.getServletPath();
                this.basePath = request.getRequestURL().toString();
                this.basePath = this.basePath.substring(0, this.basePath.indexOf(mapping));
            }
        }
        return this.basePath;
    }

    private Map<String, ApiListing> getDocs(HttpServletRequest request) {
        if (this.documentation == null || this.filters != null && !this.filters.isEmpty()) {
            String servletPath = null;
            if (request != null) {
                servletPath = request.getServletPath();
            }
            ApiParserImpl apiParser = new ApiParserImpl(this.apiInfo, this.getControllerPackages(), this.getBasePath(), servletPath, this.apiVersion, this.ignorableAnnotations, this.ignoreUnusedPathVariables, this.filters);
            this.documentation = apiParser.createApiListings();
        }
        return this.documentation;
    }

    private ResourceListing getResourceList(HttpServletRequest request) {
        if (this.resourceList == null || this.filters != null && !this.filters.isEmpty()) {
            String servletPath = null;
            if (request != null) {
                servletPath = request.getServletPath();
                servletPath = servletPath.replace("/resourceList", "");
            }
            ApiParserImpl apiParser = new ApiParserImpl(this.apiInfo, this.getControllerPackages(), this.getBasePath(), servletPath, this.apiVersion, this.ignorableAnnotations, this.ignoreUnusedPathVariables, this.filters);
            this.resourceList = apiParser.getResourceListing(this.getDocs(request));
        }
        return this.resourceList;
    }

    private List<String> getControllerPackages() {
        ArrayList<String> controllerPackages = new ArrayList<String>();
        if (this.baseControllerPackage != null && !this.baseControllerPackage.isEmpty()) {
            controllerPackages.add(this.baseControllerPackage);
        }
        if (this.additionalControllerPackages != null && !this.additionalControllerPackages.isEmpty()) {
            controllerPackages.addAll(this.additionalControllerPackages);
        }
        return controllerPackages;
    }

    public void setResourceList(ResourceListing resourceList) {
        this.resourceList = resourceList;
    }

    public String getBaseControllerPackage() {
        return this.baseControllerPackage;
    }

    public void setBaseControllerPackage(String baseControllerPackage) {
        this.baseControllerPackage = baseControllerPackage;
    }

    public List<String> getAdditionalControllerPackages() {
        return this.additionalControllerPackages;
    }

    public void setAdditionalControllerPackages(List<String> additionalControllerPackages) {
        this.additionalControllerPackages = additionalControllerPackages;
    }

    public String getBaseModelPackage() {
        return this.baseModelPackage;
    }

    public void setBaseModelPackage(String baseModelPackage) {
        this.baseModelPackage = baseModelPackage;
    }

    public List<String> getAdditionalModelPackages() {
        return this.additionalModelPackages;
    }

    public void setAdditionalModelPackages(List<String> additionalModelPackages) {
        this.additionalModelPackages = additionalModelPackages;
    }

    public Map<String, ApiListing> getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(Map<String, ApiListing> documentation) {
        this.documentation = documentation;
    }

    public List<String> getIgnorableAnnotations() {
        return this.ignorableAnnotations;
    }

    public void setIgnorableAnnotations(List<String> ignorableAnnotations) {
        this.ignorableAnnotations = ignorableAnnotations;
    }

    public boolean isIgnoreUnusedPathVariables() {
        return this.ignoreUnusedPathVariables;
    }

    public void setIgnoreUnusedPathVariables(boolean ignoreUnusedPathVariables) {
        this.ignoreUnusedPathVariables = ignoreUnusedPathVariables;
    }

    public void setBasePathFromReferer(boolean basePathFromReferer) {
        this.basePathFromReferer = basePathFromReferer;
    }

    public ApiInfo getApiInfo() {
        return this.apiInfo;
    }

    public void setApiInfo(ApiInfo apiInfo) {
        this.apiInfo = apiInfo;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }
}

