/*
 * Decompiled with CFR 0.152.
 */
package com.klinker.android.link_builder;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.text.TextPaint;
import android.util.TypedValue;
import android.view.View;
import com.klinker.android.link_builder.Link;
import com.klinker.android.link_builder.R;
import com.klinker.android.link_builder.TouchableBaseSpan;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/klinker/android/link_builder/TouchableSpan;", "Lcom/klinker/android/link_builder/TouchableBaseSpan;", "context", "Landroid/content/Context;", "link", "Lcom/klinker/android/link_builder/Link;", "(Landroid/content/Context;Lcom/klinker/android/link_builder/Link;)V", "textColor", "", "textColorOfHighlightedLink", "adjustAlpha", "color", "factor", "", "getDefaultColor", "index", "onClick", "", "widget", "Landroid/view/View;", "onLongClick", "updateDrawState", "ds", "Landroid/text/TextPaint;", "Companion", "library_release"})
public final class TouchableSpan
extends TouchableBaseSpan {
    private int textColor;
    private int textColorOfHighlightedLink;
    private final Link link;
    public static final Companion Companion = new Companion(null);

    private final int getDefaultColor(Context context, int index) {
        Intrinsics.checkExpressionValueIsNotNull((Object)R.styleable.LinkBuilder, (String)"R.styleable.LinkBuilder");
        TypedArray array = TouchableSpan.Companion.obtainStyledAttrsFromThemeAttr(context, R.attr.linkBuilderStyle, R.styleable.LinkBuilder);
        int color = array.getColor(index, Link.Companion.getDEFAULT_COLOR());
        array.recycle();
        return color;
    }

    @Override
    public void onClick(@NotNull View widget) {
        Intrinsics.checkParameterIsNotNull((Object)widget, (String)"widget");
        if (this.link.text != null) {
            Link.OnClickListener onClickListener = this.link.clickListener;
            if (onClickListener != null) {
                String string = this.link.text;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                onClickListener.onClick(string);
            }
        }
        super.onClick(widget);
    }

    @Override
    public void onLongClick(@NotNull View widget) {
        Intrinsics.checkParameterIsNotNull((Object)widget, (String)"widget");
        if (this.link.text != null) {
            Link.OnLongClickListener onLongClickListener = this.link.longClickListener;
            if (onLongClickListener != null) {
                String string = this.link.text;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                onLongClickListener.onLongClick(string);
            }
        }
        super.onLongClick(widget);
    }

    public final int adjustAlpha(int color, float factor) {
        int alpha = Math.round((float)Color.alpha((int)color) * factor);
        int red = Color.red((int)color);
        int green = Color.green((int)color);
        int blue = Color.blue((int)color);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    public void updateDrawState(@NotNull TextPaint ds) {
        Intrinsics.checkParameterIsNotNull((Object)ds, (String)"ds");
        super.updateDrawState(ds);
        ds.setUnderlineText(this.link.underlined);
        ds.setFakeBoldText(this.link.bold);
        ds.setColor(this.isTouched() ? this.textColorOfHighlightedLink : this.textColor);
        int n = ds.bgColor = this.isTouched() ? this.adjustAlpha(this.textColor, this.link.highlightAlpha) : 0;
        if (this.link.typeface != null) {
            ds.setTypeface(this.link.typeface);
        }
    }

    public TouchableSpan(@NotNull Context context, @NotNull Link link) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
        this.link = link;
        this.textColor = this.link.textColor == 0 ? this.getDefaultColor(context, R.styleable.LinkBuilder_defaultLinkColor) : this.link.textColor;
        if (this.link.textColorOfHighlightedLink == 0) {
            this.textColorOfHighlightedLink = this.getDefaultColor(context, R.styleable.LinkBuilder_defaultTextColorOfHighlightedLink);
            if (this.textColorOfHighlightedLink == Link.Companion.getDEFAULT_COLOR()) {
                this.textColorOfHighlightedLink = this.textColor;
            }
        } else {
            this.textColorOfHighlightedLink = this.link.textColorOfHighlightedLink;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/klinker/android/link_builder/TouchableSpan$Companion;", "", "()V", "obtainStyledAttrsFromThemeAttr", "Landroid/content/res/TypedArray;", "context", "Landroid/content/Context;", "themeAttr", "", "styleAttrs", "", "library_release"})
    public static final class Companion {
        private final TypedArray obtainStyledAttrsFromThemeAttr(Context context, int themeAttr, int[] styleAttrs) {
            TypedValue outValue = new TypedValue();
            context.getTheme().resolveAttribute(themeAttr, outValue, true);
            int styleResId = outValue.resourceId;
            TypedArray typedArray = context.obtainStyledAttributes(styleResId, styleAttrs);
            Intrinsics.checkExpressionValueIsNotNull((Object)typedArray, (String)"context.obtainStyledAttr\u2026s(styleResId, styleAttrs)");
            return typedArray;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

