/*
 * Decompiled with CFR 0.152.
 */
package com.karuslabs.utilitary.snippet;

import com.karuslabs.utilitary.type.AnnotationValuePrinter;
import java.util.Objects;
import javax.lang.model.element.AnnotationMirror;

public class Line
implements CharSequence,
Comparable<Line> {
    private final String value;
    public final int column;
    public final int position;

    public static Line annotation(AnnotationMirror annotation, int column, int position) {
        return new Line(AnnotationValuePrinter.annotation(annotation), column, position);
    }

    public static Line empty(int column, int position) {
        return new Line("", column, position);
    }

    public Line(String value, int column, int position) {
        this.value = value;
        this.column = column;
        this.position = position;
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.value.subSequence(start, end);
    }

    @Override
    public int compareTo(Line other) {
        int columns = Integer.compare(this.column, other.column);
        if (columns != 0) {
            return columns;
        }
        return Integer.compare(this.position, other.position);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Line)) {
            return false;
        }
        Line line = (Line)other;
        return this.value.equals(line.value) && this.column == line.column && this.position == line.position;
    }

    public int hashCode() {
        return Objects.hash(this.value, this.column, this.position);
    }

    @Override
    public String toString() {
        return this.value;
    }
}

