/*
 * Decompiled with CFR 0.152.
 */
package com.jtelegram.api.test;

import com.jtelegram.api.TelegramBot;
import com.jtelegram.api.TelegramBotRegistry;
import com.jtelegram.api.chat.Chat;
import com.jtelegram.api.chat.id.ChatId;
import com.jtelegram.api.commands.Command;
import com.jtelegram.api.commands.filters.CommandFilter;
import com.jtelegram.api.commands.filters.TextFilter;
import com.jtelegram.api.events.message.TextMessageEvent;
import com.jtelegram.api.requests.framework.TelegramRequest;
import com.jtelegram.api.requests.message.framework.ParseMode;
import com.jtelegram.api.requests.message.send.SendText;
import com.jtelegram.api.test.ResourceTestModule;
import com.jtelegram.api.test.TestModule;
import com.jtelegram.api.test.message.ForwardMessageTest;
import com.jtelegram.api.test.message.LiveLocationTest;
import com.jtelegram.api.test.message.LocationMessageTest;
import com.jtelegram.api.test.message.PhotoTest;
import com.jtelegram.api.test.message.TextBuilderTest;
import com.jtelegram.api.test.message.VenueTest;
import com.jtelegram.api.test.misc.UserProfilePhotosTest;
import com.jtelegram.api.update.PollingUpdateProvider;
import com.jtelegram.api.update.UpdateProvider;
import com.jtelegram.api.webhooks.WebhookUpdateProvider;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.JksOptions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BotMainTest {
    private TelegramBotRegistry registry;
    private TelegramBot bot;
    private final Map<String, TestModule> modules = new HashMap<String, TestModule>();

    private BotMainTest(String[] args) throws Exception {
        Object provider = args[1].equalsIgnoreCase("webhooks") ? WebhookUpdateProvider.builder().serverOptions(new HttpServerOptions().setSsl(true).setKeyStoreOptions(new JksOptions().setPath("bot.jks").setPassword("aaaaaa")).setPort(443).setHost(args[2])).selfSignedCertificate(new File("bot-certificate.pem")).build() : new PollingUpdateProvider();
        this.registry = TelegramBotRegistry.builder().updateProvider((UpdateProvider)provider).build();
        this.registry.registerBot(args[0], (bot, error) -> {
            if (error != null) {
                System.out.println("Could not log in!");
                error.printStackTrace();
                System.exit(-1);
                return;
            }
            this.bot = bot;
            System.out.printf("Logged in as @%s\n", bot.getBotInfo().getUsername());
            this.registerModules();
            bot.getCommandRegistry().registerCommand((CommandFilter)new TextFilter("test", false, new CommandFilter[]{this::handleTestCommand}), new CommandFilter[0]);
        });
    }

    public static void main(String[] args) throws Exception {
        new BotMainTest(args);
    }

    private boolean handleTestCommand(TextMessageEvent event, Command command) {
        List args = command.getArgs();
        if (args.size() == 0) {
            this.bot.perform((TelegramRequest)SendText.builder().text("Please specify a module to test, or 'all' to perform all applicable tests for this chat").chatId((ChatId)ChatId.of((Chat)command.getBaseMessage().getChat())).build());
            return true;
        }
        String moduleName = (String)args.get(0);
        String[] moduleArgs = (args.size() > 1 ? args.subList(1, args.size()) : new ArrayList()).toArray(new String[0]);
        if ("all".equalsIgnoreCase(moduleName)) {
            List<TestModule> applicableModules = this.modules.values().stream().filter(m -> m.validate(command) == null).collect(Collectors.toList());
            applicableModules.forEach(m -> this.testModule((TestModule)m, moduleArgs, command));
            return true;
        }
        TestModule module = this.modules.get(moduleName.toLowerCase());
        if (module != null) {
            this.testModule(module, moduleArgs, command);
            return true;
        }
        this.sendError(command, "No module found by the name of " + moduleName);
        return true;
    }

    private void testModule(TestModule module, String[] args, Command command) {
        String error = module.validate(command);
        if (error != null) {
            this.sendError(command, "Test cannot be performed due to " + error);
            return;
        }
        try {
            module.handle(args, command);
        }
        catch (Exception ex) {
            this.sendError(command, "Test failed due to " + ex.getClass().getSimpleName() + "! Check logs for more details");
            ex.printStackTrace();
        }
    }

    private void sendError(Command command, String error) {
        this.bot.perform((TelegramRequest)SendText.builder().parseMode(ParseMode.MARKDOWN).text("*ERROR:* " + error).chatId((ChatId)ChatId.of((Chat)command.getBaseMessage().getChat())).build());
    }

    private void registerModule(TestModule module) {
        this.modules.put(module.getName(), module);
    }

    private void registerModules() {
        this.registerModule(new LiveLocationTest(this.bot));
        this.registerModule(new LocationMessageTest(this.bot));
        this.registerModule(new ForwardMessageTest(this.bot));
        this.registerModule(new PhotoTest(this.bot));
        this.registerModule(new VenueTest(this.bot));
        this.registerModule(new UserProfilePhotosTest(this.bot));
        this.registerModule(new TextBuilderTest(this.bot));
        this.prepareResources();
    }

    private boolean prepareResourceDirectory() {
        File resourcesDir = new File("test-resources");
        if (resourcesDir.exists() && resourcesDir.isDirectory()) {
            return false;
        }
        resourcesDir.delete();
        resourcesDir.mkdirs();
        return true;
    }

    private void prepareResources() {
        if (!this.prepareResourceDirectory()) {
            return;
        }
        ArrayList failedModules = new ArrayList();
        this.modules.values().stream().filter(m -> m instanceof ResourceTestModule).forEach(m -> {
            FileOutputStream output;
            ResourceTestModule module = (ResourceTestModule)m;
            File file = module.getResourceFile();
            if (file.exists()) {
                return;
            }
            try {
                file.createNewFile();
            }
            catch (IOException ex) {
                System.out.println("Failed loading " + module.getName() + ": Could not create new resource file");
                ex.printStackTrace();
                failedModules.add(m);
                return;
            }
            try {
                output = new FileOutputStream(file);
            }
            catch (FileNotFoundException ignored) {
                return;
            }
            InputStream input = module.getResourceStream();
            System.out.println("Transferring " + module.getResourceName() + " from executable to file...");
            try {
                byte[] buffer = new byte[1024];
                while (input.available() > 0) {
                    int lengthRead = input.read(buffer);
                    if (lengthRead == -1) continue;
                    output.write(buffer, 0, lengthRead);
                }
                output.close();
                input.close();
                System.out.println("Successfully transferred " + module.getResourceName() + " to " + module.getResourceFile().getPath());
            }
            catch (IOException ex) {
                System.out.println("Failed loading " + module.getResourceName() + " while writing to file!");
                ex.printStackTrace();
                failedModules.add(m);
            }
        });
    }
}

