/*
 * Decompiled with CFR 0.152.
 */
package com.jpardogo.android.googleprogressbar.library;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Interpolator;

public class GoogleMusicDicesDrawable
extends Drawable
implements Drawable.Callback {
    private static final int DICE_SIDE_COLOR = Color.parseColor((String)"#FFDBDBDB");
    private static final int DICE_SIDE_SHADOW_COLOR = Color.parseColor((String)"#FFB8B8B9");
    private static final int ANIMATION_DURATION = 350;
    private static final int ANIMATION_START_DELAY = 150;
    private static final Interpolator ACCELERATE_INTERPOLATOR = new AccelerateInterpolator();
    private Paint mPaint;
    private Paint mPaintShadow;
    private Paint mPaintCircle;
    private int mSize;
    private float mScale;
    private DiceRotation mDiceRotation;
    private DiceState[] mDiceStates;
    private int mDiceState;

    public GoogleMusicDicesDrawable() {
        this.init();
    }

    private void init() {
        this.mPaint = new Paint(1);
        this.mPaint.setColor(DICE_SIDE_COLOR);
        this.mPaintShadow = new Paint(1);
        this.mPaintShadow.setColor(DICE_SIDE_SHADOW_COLOR);
        this.mPaintCircle = new Paint(1);
        this.mPaintCircle.setColor(-1);
        this.mDiceStates = new DiceState[]{new DiceState(DiceSide.ONE, DiceSide.THREE), new DiceState(DiceSide.TWO, DiceSide.THREE), new DiceState(DiceSide.TWO, DiceSide.SIX), new DiceState(DiceSide.FOUR, DiceSide.SIX), new DiceState(DiceSide.FOUR, DiceSide.FIVE), new DiceState(DiceSide.ONE, DiceSide.FIVE)};
        this.mDiceRotation = DiceRotation.LEFT;
        this.initObjectAnimator();
    }

    private void initObjectAnimator() {
        final ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scale", (float[])new float[]{0.0f, 1.0f});
        objectAnimator.setInterpolator((TimeInterpolator)ACCELERATE_INTERPOLATOR);
        objectAnimator.setDuration(350L);
        objectAnimator.setStartDelay(150L);
        objectAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                GoogleMusicDicesDrawable.this.mScale = 0.0f;
                GoogleMusicDicesDrawable.this.mDiceState++;
                if (GoogleMusicDicesDrawable.this.mDiceState == GoogleMusicDicesDrawable.this.mDiceStates.length) {
                    GoogleMusicDicesDrawable.this.mDiceState = 0;
                }
                GoogleMusicDicesDrawable.this.mDiceRotation = GoogleMusicDicesDrawable.this.mDiceRotation.invert();
                objectAnimator.start();
            }
        });
        objectAnimator.start();
    }

    public void draw(Canvas canvas) {
        if (this.mDiceRotation != null) {
            switch (this.mDiceRotation) {
                case DOWN: {
                    this.drawScaleY(canvas);
                    break;
                }
                case LEFT: {
                    this.drawScaleX(canvas);
                }
            }
        }
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
        this.mPaintShadow.setAlpha(alpha);
        this.mPaintCircle.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
        this.mPaintShadow.setColorFilter(cf);
        this.mPaintCircle.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mSize = bounds.width();
    }

    public void invalidateDrawable(Drawable who) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable((Drawable)this, what, when);
        }
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable((Drawable)this, what);
        }
    }

    private void drawScaleX(Canvas canvas) {
        canvas.save();
        Matrix matrix = new Matrix();
        matrix.preScale(1.0f - this.mScale, 1.0f, 0.0f, (float)(this.mSize / 2));
        canvas.concat(matrix);
        this.drawDiceSide(canvas, this.mDiceStates[this.mDiceState].side1, this.mScale > 0.1f);
        canvas.restore();
        canvas.save();
        matrix = new Matrix();
        matrix.preScale(this.mScale, 1.0f, (float)this.mSize, (float)(this.mSize / 2));
        canvas.concat(matrix);
        this.drawDiceSide(canvas, this.mDiceStates[this.mDiceState].side2, false);
        canvas.restore();
    }

    private void drawScaleY(Canvas canvas) {
        canvas.save();
        Matrix matrix = new Matrix();
        matrix.preScale(1.0f, this.mScale, (float)(this.mSize / 2), 0.0f);
        canvas.concat(matrix);
        this.drawDiceSide(canvas, this.mDiceStates[this.mDiceState].side1, false);
        canvas.restore();
        canvas.save();
        matrix = new Matrix();
        matrix.preScale(1.0f, 1.0f - this.mScale, (float)(this.mSize / 2), (float)this.mSize);
        canvas.concat(matrix);
        this.drawDiceSide(canvas, this.mDiceStates[this.mDiceState].side2, this.mScale > 0.1f);
        canvas.restore();
    }

    private void drawDiceSide(Canvas canvas, DiceSide side, boolean shadow) {
        int circleRadius = this.mSize / 10;
        canvas.drawRect(0.0f, 0.0f, (float)this.mSize, (float)this.mSize, shadow ? this.mPaintShadow : this.mPaint);
        switch (side) {
            case ONE: {
                canvas.drawCircle((float)(this.mSize / 2), (float)(this.mSize / 2), (float)circleRadius, this.mPaintCircle);
                break;
            }
            case TWO: {
                canvas.drawCircle((float)(this.mSize / 4), (float)(this.mSize - this.mSize / 4), (float)circleRadius, this.mPaintCircle);
                canvas.drawCircle((float)(this.mSize - this.mSize / 4), (float)(this.mSize / 4), (float)circleRadius, this.mPaintCircle);
                break;
            }
            case THREE: {
                canvas.drawCircle((float)(this.mSize / 2), (float)(this.mSize / 2), (float)circleRadius, this.mPaintCircle);
                canvas.drawCircle((float)(this.mSize / 4), (float)(this.mSize / 4), (float)circleRadius, this.mPaintCircle);
                canvas.drawCircle((float)(this.mSize - this.mSize / 4), (float)(this.mSize - this.mSize / 4), (float)(this.mSize / 10), this.mPaintCircle);
                break;
            }
            case FOUR: {
                canvas.drawCircle((float)(this.mSize / 4), (float)(this.mSize / 4), (float)circleRadius, this.mPaintCircle);
                canvas.drawCircle((float)(this.mSize / 4), (float)(this.mSize - this.mSize / 4), (float)circleRadius, this.mPaintCircle);
                canvas.drawCircle((float)(this.mSize - this.mSize / 4), (float)(this.mSize - this.mSize / 4), (float)circleRadius, this.mPaintCircle);
                canvas.drawCircle((float)(this.mSize - this.mSize / 4), (float)(this.mSize / 4), (float)circleRadius, this.mPaintCircle);
                break;
            }
            case FIVE: {
                canvas.drawCircle((float)(this.mSize / 2), (float)(this.mSize / 2), (float)circleRadius, this.mPaintCircle);
                canvas.drawCircle((float)(this.mSize / 4), (float)(this.mSize / 4), (float)circleRadius, this.mPaintCircle);
                canvas.drawCircle((float)(this.mSize / 4), (float)(this.mSize - this.mSize / 4), (float)circleRadius, this.mPaintCircle);
                canvas.drawCircle((float)(this.mSize - this.mSize / 4), (float)(this.mSize - this.mSize / 4), (float)circleRadius, this.mPaintCircle);
                canvas.drawCircle((float)(this.mSize - this.mSize / 4), (float)(this.mSize / 4), (float)circleRadius, this.mPaintCircle);
                break;
            }
            case SIX: {
                canvas.drawCircle((float)(this.mSize / 4), (float)(this.mSize / 4), (float)circleRadius, this.mPaintCircle);
                canvas.drawCircle((float)(this.mSize / 4), (float)(this.mSize / 2), (float)circleRadius, this.mPaintCircle);
                canvas.drawCircle((float)(this.mSize / 4), (float)(this.mSize - this.mSize / 4), (float)circleRadius, this.mPaintCircle);
                canvas.drawCircle((float)(this.mSize - this.mSize / 4), (float)(this.mSize / 4), (float)circleRadius, this.mPaintCircle);
                canvas.drawCircle((float)(this.mSize - this.mSize / 4), (float)(this.mSize / 2), (float)circleRadius, this.mPaintCircle);
                canvas.drawCircle((float)(this.mSize - this.mSize / 4), (float)(this.mSize - this.mSize / 4), (float)circleRadius, this.mPaintCircle);
            }
        }
    }

    float getScale() {
        return this.mScale;
    }

    void setScale(float scale) {
        this.mScale = scale;
    }

    public static class Builder {
        public Drawable build() {
            return new GoogleMusicDicesDrawable();
        }
    }

    private class DiceState {
        private DiceSide side1;
        private DiceSide side2;

        DiceState(DiceSide side1, DiceSide side2) {
            this.side1 = side1;
            this.side2 = side2;
        }
    }

    private static enum DiceRotation {
        LEFT,
        DOWN;


        DiceRotation invert() {
            return this == LEFT ? DOWN : LEFT;
        }
    }

    private static enum DiceSide {
        ONE,
        TWO,
        THREE,
        FOUR,
        FIVE,
        SIX;

    }
}

