/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioAttributes;
import android.media.MediaPlayer;
import android.os.Build;
import android.os.Vibrator;
import android.util.Log;
import com.google.zxing.client.android.R;
import java.io.IOException;

public final class BeepManager {
    private static final String TAG = BeepManager.class.getSimpleName();
    private static final float BEEP_VOLUME = 0.1f;
    private static final long VIBRATE_DURATION = 200L;
    private final Context context;
    private boolean beepEnabled = true;
    private boolean vibrateEnabled = false;

    public BeepManager(Activity activity) {
        activity.setVolumeControlStream(3);
        this.context = activity.getApplicationContext();
    }

    public boolean isBeepEnabled() {
        return this.beepEnabled;
    }

    public void setBeepEnabled(boolean beepEnabled) {
        this.beepEnabled = beepEnabled;
    }

    public boolean isVibrateEnabled() {
        return this.vibrateEnabled;
    }

    public void setVibrateEnabled(boolean vibrateEnabled) {
        this.vibrateEnabled = vibrateEnabled;
    }

    @SuppressLint(value={"MissingPermission"})
    public synchronized void playBeepSoundAndVibrate() {
        Vibrator vibrator;
        if (this.beepEnabled) {
            this.playBeepSound();
        }
        if (this.vibrateEnabled && (vibrator = (Vibrator)this.context.getSystemService("vibrator")) != null) {
            vibrator.vibrate(200L);
        }
    }

    public MediaPlayer playBeepSound() {
        MediaPlayer mediaPlayer = new MediaPlayer();
        if (Build.VERSION.SDK_INT >= 21) {
            mediaPlayer.setAudioAttributes(new AudioAttributes.Builder().setContentType(2).build());
        } else {
            mediaPlayer.setAudioStreamType(3);
        }
        mediaPlayer.setOnCompletionListener(mp -> {
            mp.stop();
            mp.reset();
            mp.release();
        });
        mediaPlayer.setOnErrorListener((mp, what, extra) -> {
            Log.w((String)TAG, (String)("Failed to beep " + what + ", " + extra));
            mp.stop();
            mp.reset();
            mp.release();
            return true;
        });
        try {
            try (AssetFileDescriptor file = this.context.getResources().openRawResourceFd(R.raw.zxing_beep);){
                mediaPlayer.setDataSource(file.getFileDescriptor(), file.getStartOffset(), file.getLength());
            }
            mediaPlayer.setVolume(0.1f, 0.1f);
            mediaPlayer.prepare();
            mediaPlayer.start();
            return mediaPlayer;
        }
        catch (IOException ioe) {
            Log.w((String)TAG, (Throwable)ioe);
            mediaPlayer.reset();
            mediaPlayer.release();
            return null;
        }
    }
}

