/*
 * Decompiled with CFR 0.152.
 */
package com.journeyapps.barcodescanner.camera;

import android.graphics.Rect;
import android.util.Log;
import com.journeyapps.barcodescanner.Size;
import com.journeyapps.barcodescanner.camera.PreviewScalingStrategy;

public class FitCenterStrategy
extends PreviewScalingStrategy {
    private static final String TAG = FitCenterStrategy.class.getSimpleName();

    @Override
    protected float getScore(Size size, Size desired) {
        if (size.width <= 0 || size.height <= 0) {
            return 0.0f;
        }
        Size scaled = size.scaleFit(desired);
        float scaleRatio = (float)scaled.width * 1.0f / (float)size.width;
        float scaleScore = scaleRatio > 1.0f ? (float)Math.pow(1.0f / scaleRatio, 1.1) : scaleRatio;
        float cropRatio = (float)desired.width * 1.0f / (float)scaled.width * ((float)desired.height * 1.0f / (float)scaled.height);
        float cropScore = 1.0f / cropRatio / cropRatio / cropRatio;
        return scaleScore * cropScore;
    }

    @Override
    public Rect scalePreview(Size previewSize, Size viewfinderSize) {
        Size scaledPreview = previewSize.scaleFit(viewfinderSize);
        Log.i((String)TAG, (String)("Preview: " + previewSize + "; Scaled: " + scaledPreview + "; Want: " + viewfinderSize));
        int dx = (scaledPreview.width - viewfinderSize.width) / 2;
        int dy = (scaledPreview.height - viewfinderSize.height) / 2;
        return new Rect(-dx, -dy, scaledPreview.width - dx, scaledPreview.height - dy);
    }
}

