/*
 * Decompiled with CFR 0.152.
 */
package com.journeyapps.barcodescanner;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.ResultPoint;
import com.journeyapps.barcodescanner.RawImageData;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class SourceData {
    private RawImageData data;
    private int imageFormat;
    private int rotation;
    private Rect cropRect;
    private int scalingFactor = 1;
    private boolean previewMirrored;

    public SourceData(byte[] data, int dataWidth, int dataHeight, int imageFormat, int rotation) {
        this.data = new RawImageData(data, dataWidth, dataHeight);
        this.rotation = rotation;
        this.imageFormat = imageFormat;
        if (dataWidth * dataHeight > data.length) {
            throw new IllegalArgumentException("Image data does not match the resolution. " + dataWidth + "x" + dataHeight + " > " + data.length);
        }
    }

    public Rect getCropRect() {
        return this.cropRect;
    }

    public void setCropRect(Rect cropRect) {
        this.cropRect = cropRect;
    }

    public boolean isPreviewMirrored() {
        return this.previewMirrored;
    }

    public void setPreviewMirrored(boolean previewMirrored) {
        this.previewMirrored = previewMirrored;
    }

    public int getScalingFactor() {
        return this.scalingFactor;
    }

    public void setScalingFactor(int scalingFactor) {
        this.scalingFactor = scalingFactor;
    }

    public byte[] getData() {
        return this.data.getData();
    }

    public int getDataWidth() {
        return this.data.getWidth();
    }

    public int getDataHeight() {
        return this.data.getHeight();
    }

    public ResultPoint translateResultPoint(ResultPoint point) {
        float x = point.getX() * (float)this.scalingFactor + (float)this.cropRect.left;
        float y = point.getY() * (float)this.scalingFactor + (float)this.cropRect.top;
        if (this.previewMirrored) {
            x = (float)this.data.getWidth() - x;
        }
        return new ResultPoint(x, y);
    }

    public boolean isRotated() {
        return this.rotation % 180 != 0;
    }

    public int getImageFormat() {
        return this.imageFormat;
    }

    public PlanarYUVLuminanceSource createSource() {
        RawImageData rotated = this.data.rotateCameraPreview(this.rotation);
        RawImageData scaled = rotated.cropAndScale(this.cropRect, this.scalingFactor);
        return new PlanarYUVLuminanceSource(scaled.getData(), scaled.getWidth(), scaled.getHeight(), 0, 0, scaled.getWidth(), scaled.getHeight(), false);
    }

    public Bitmap getBitmap() {
        return this.getBitmap(1);
    }

    public Bitmap getBitmap(int scaleFactor) {
        return this.getBitmap(this.cropRect, scaleFactor);
    }

    public Bitmap getBitmap(Rect cropRect, int scaleFactor) {
        if (cropRect == null) {
            cropRect = new Rect(0, 0, this.data.getWidth(), this.data.getHeight());
        } else if (this.isRotated()) {
            cropRect = new Rect(cropRect.top, cropRect.left, cropRect.bottom, cropRect.right);
        }
        YuvImage img = new YuvImage(this.data.getData(), this.imageFormat, this.data.getWidth(), this.data.getHeight(), null);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        img.compressToJpeg(cropRect, 90, (OutputStream)buffer);
        byte[] jpegData = buffer.toByteArray();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = scaleFactor;
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])jpegData, (int)0, (int)jpegData.length, (BitmapFactory.Options)options);
        if (this.rotation != 0) {
            Matrix imageMatrix = new Matrix();
            imageMatrix.postRotate((float)this.rotation);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)imageMatrix, (boolean)false);
        }
        return bitmap;
    }
}

