/*
 * Decompiled with CFR 0.152.
 */
package com.joanzapata.pdfview.model;

import android.graphics.Bitmap;
import android.graphics.RectF;

public class PagePart {
    private int userPage;
    private int page;
    private Bitmap renderedBitmap;
    private float width;
    private float height;
    private RectF pageRelativeBounds;
    private boolean thumbnail;
    private int cacheOrder;

    public PagePart(int userPage, int page, Bitmap renderedBitmap, float width, float height, RectF pageRelativeBounds, boolean thumbnail, int cacheOrder) {
        this.userPage = userPage;
        this.page = page;
        this.renderedBitmap = renderedBitmap;
        this.pageRelativeBounds = pageRelativeBounds;
        this.thumbnail = thumbnail;
        this.cacheOrder = cacheOrder;
    }

    public int getCacheOrder() {
        return this.cacheOrder;
    }

    public int getPage() {
        return this.page;
    }

    public int getUserPage() {
        return this.userPage;
    }

    public Bitmap getRenderedBitmap() {
        return this.renderedBitmap;
    }

    public RectF getPageRelativeBounds() {
        return this.pageRelativeBounds;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public boolean isThumbnail() {
        return this.thumbnail;
    }

    public void setCacheOrder(int cacheOrder) {
        this.cacheOrder = cacheOrder;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PagePart)) {
            return false;
        }
        PagePart part = (PagePart)obj;
        return part.getPage() == this.page && part.getUserPage() == this.userPage && part.getWidth() == this.width && part.getHeight() == this.height && part.getPageRelativeBounds().left == this.pageRelativeBounds.left && part.getPageRelativeBounds().right == this.pageRelativeBounds.right && part.getPageRelativeBounds().top == this.pageRelativeBounds.top && part.getPageRelativeBounds().bottom == this.pageRelativeBounds.bottom;
    }
}

