/*
 * Decompiled with CFR 0.152.
 */
package com.joanzapata.iconify.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.support.v4.view.ViewCompat;
import android.text.SpannableStringBuilder;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.TextView;
import com.joanzapata.iconify.Icon;
import com.joanzapata.iconify.internal.CustomTypefaceSpan;
import com.joanzapata.iconify.internal.HasOnViewAttachListener;
import com.joanzapata.iconify.internal.IconFontDescriptorWrapper;
import java.util.List;

public final class ParsingUtil {
    private static final String ANDROID_PACKAGE_NAME = "android";

    private ParsingUtil() {
    }

    public static CharSequence parse(Context context, List<IconFontDescriptorWrapper> iconFontDescriptors, CharSequence text, final TextView target) {
        context = context.getApplicationContext();
        if (text == null) {
            return text;
        }
        SpannableStringBuilder spannableBuilder = new SpannableStringBuilder(text);
        ParsingUtil.recursivePrepareSpannableIndexes(context, text.toString(), spannableBuilder, iconFontDescriptors, 0);
        boolean isAnimated = ParsingUtil.hasAnimatedSpans(spannableBuilder);
        if (isAnimated) {
            if (target == null) {
                throw new IllegalArgumentException("You can't use \"spin\" without providing the target TextView.");
            }
            if (!(target instanceof HasOnViewAttachListener)) {
                throw new IllegalArgumentException(target.getClass().getSimpleName() + " does not implement " + "HasOnViewAttachListener. Please use IconTextView, IconButton or IconToggleButton.");
            }
            ((HasOnViewAttachListener)target).setOnViewAttachListener(new HasOnViewAttachListener.OnViewAttachListener(){
                boolean isAttached = false;

                @Override
                public void onAttach() {
                    this.isAttached = true;
                    ViewCompat.postOnAnimation((View)target, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (isAttached) {
                                target.invalidate();
                                ViewCompat.postOnAnimation((View)target, (Runnable)this);
                            }
                        }
                    });
                }

                @Override
                public void onDetach() {
                    this.isAttached = false;
                }
            });
        } else if (target instanceof HasOnViewAttachListener) {
            ((HasOnViewAttachListener)target).setOnViewAttachListener(null);
        }
        return spannableBuilder;
    }

    private static boolean hasAnimatedSpans(SpannableStringBuilder spannableBuilder) {
        CustomTypefaceSpan[] spans;
        for (CustomTypefaceSpan span : spans = (CustomTypefaceSpan[])spannableBuilder.getSpans(0, spannableBuilder.length(), CustomTypefaceSpan.class)) {
            if (!span.isAnimated()) continue;
            return true;
        }
        return false;
    }

    private static void recursivePrepareSpannableIndexes(Context context, String fullText, SpannableStringBuilder text, List<IconFontDescriptorWrapper> iconFontDescriptors, int start) {
        String stringText = text.toString();
        int startIndex = stringText.indexOf("{", start);
        if (startIndex == -1) {
            return;
        }
        int endIndex = stringText.indexOf("}", startIndex) + 1;
        if (endIndex == -1) {
            return;
        }
        String expression = stringText.substring(startIndex + 1, endIndex - 1);
        String[] strokes = expression.split(" ");
        String key = strokes[0];
        IconFontDescriptorWrapper iconFontDescriptor = null;
        Icon icon = null;
        for (int i = 0; i < iconFontDescriptors.size() && (icon = (iconFontDescriptor = iconFontDescriptors.get(i)).getIcon(key)) == null; ++i) {
        }
        if (icon == null) {
            ParsingUtil.recursivePrepareSpannableIndexes(context, fullText, text, iconFontDescriptors, endIndex);
            return;
        }
        float iconSizePx = -1.0f;
        int iconColor = Integer.MAX_VALUE;
        float iconSizeRatio = -1.0f;
        boolean spin = false;
        boolean baselineAligned = false;
        for (int i = 1; i < strokes.length; ++i) {
            String stroke = strokes[i];
            if (stroke.equalsIgnoreCase("spin")) {
                spin = true;
                continue;
            }
            if (stroke.equalsIgnoreCase("baseline")) {
                baselineAligned = true;
                continue;
            }
            if (stroke.matches("([0-9]*(\\.[0-9]*)?)dp")) {
                iconSizePx = ParsingUtil.dpToPx(context, Float.valueOf(stroke.substring(0, stroke.length() - 2)).floatValue());
                continue;
            }
            if (stroke.matches("([0-9]*(\\.[0-9]*)?)sp")) {
                iconSizePx = ParsingUtil.spToPx(context, Float.valueOf(stroke.substring(0, stroke.length() - 2)).floatValue());
                continue;
            }
            if (stroke.matches("([0-9]*)px")) {
                iconSizePx = Integer.valueOf(stroke.substring(0, stroke.length() - 2)).intValue();
                continue;
            }
            if (stroke.matches("@dimen/(.*)")) {
                iconSizePx = ParsingUtil.getPxFromDimen(context, context.getPackageName(), stroke.substring(7));
                if (!(iconSizePx < 0.0f)) continue;
                throw new IllegalArgumentException("Unknown resource " + stroke + " in \"" + fullText + "\"");
            }
            if (stroke.matches("@android:dimen/(.*)")) {
                iconSizePx = ParsingUtil.getPxFromDimen(context, ANDROID_PACKAGE_NAME, stroke.substring(15));
                if (!(iconSizePx < 0.0f)) continue;
                throw new IllegalArgumentException("Unknown resource " + stroke + " in \"" + fullText + "\"");
            }
            if (stroke.matches("([0-9]*(\\.[0-9]*)?)%")) {
                iconSizeRatio = Float.valueOf(stroke.substring(0, stroke.length() - 1)).floatValue() / 100.0f;
                continue;
            }
            if (stroke.matches("#([0-9A-Fa-f]{6}|[0-9A-Fa-f]{8})")) {
                iconColor = Color.parseColor((String)stroke);
                continue;
            }
            if (stroke.matches("@color/(.*)")) {
                iconColor = ParsingUtil.getColorFromResource(context, context.getPackageName(), stroke.substring(7));
                if (iconColor != Integer.MAX_VALUE) continue;
                throw new IllegalArgumentException("Unknown resource " + stroke + " in \"" + fullText + "\"");
            }
            if (stroke.matches("@android:color/(.*)")) {
                iconColor = ParsingUtil.getColorFromResource(context, ANDROID_PACKAGE_NAME, stroke.substring(15));
                if (iconColor != Integer.MAX_VALUE) continue;
                throw new IllegalArgumentException("Unknown resource " + stroke + " in \"" + fullText + "\"");
            }
            throw new IllegalArgumentException("Unknown expression " + stroke + " in \"" + fullText + "\"");
        }
        text = text.replace(startIndex, endIndex, (CharSequence)("" + icon.character()));
        text.setSpan((Object)new CustomTypefaceSpan(icon, iconFontDescriptor.getTypeface(context), iconSizePx, iconSizeRatio, iconColor, spin, baselineAligned), startIndex, startIndex + 1, 17);
        ParsingUtil.recursivePrepareSpannableIndexes(context, fullText, text, iconFontDescriptors, startIndex);
    }

    public static float getPxFromDimen(Context context, String packageName, String resName) {
        Resources resources = context.getResources();
        int resId = resources.getIdentifier(resName, "dimen", packageName);
        if (resId <= 0) {
            return -1.0f;
        }
        return resources.getDimension(resId);
    }

    public static int getColorFromResource(Context context, String packageName, String resName) {
        Resources resources = context.getResources();
        int resId = resources.getIdentifier(resName, "color", packageName);
        if (resId <= 0) {
            return Integer.MAX_VALUE;
        }
        return resources.getColor(resId);
    }

    public static float dpToPx(Context context, float dp) {
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static float spToPx(Context context, float sp) {
        return TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }
}

