/*
 * Decompiled with CFR 0.152.
 */
package com.joanzapata.iconify.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.text.SpannableString;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.util.TypedValue;
import com.joanzapata.iconify.Icon;
import com.joanzapata.iconify.internal.CustomTypefaceSpan;
import com.joanzapata.iconify.internal.IconFontDescriptorWrapper;
import java.util.List;

public final class ParsingUtil {
    private ParsingUtil() {
    }

    public static SpannableString parse(Context context, List<IconFontDescriptorWrapper> iconFontDescriptors, CharSequence text) {
        context = context.getApplicationContext();
        SparseArray accumulator = new SparseArray();
        String result = ParsingUtil.recursivePrepareSpannableIndexes(context, text.toString(), new StringBuilder(text), iconFontDescriptors, (SparseArray<CustomTypefaceSpan>)accumulator, 0);
        SpannableString spannableString = SpannableString.valueOf((CharSequence)result);
        int size = accumulator.size();
        for (int i = 0; i < size; ++i) {
            int index = accumulator.keyAt(i);
            CustomTypefaceSpan descriptor = (CustomTypefaceSpan)((Object)accumulator.valueAt(i));
            spannableString.setSpan((Object)descriptor, index, index + 1, 17);
        }
        return spannableString;
    }

    private static String recursivePrepareSpannableIndexes(Context context, String fullText, StringBuilder text, List<IconFontDescriptorWrapper> iconFontDescriptors, SparseArray<CustomTypefaceSpan> accumulator, int start) {
        int startIndex = text.indexOf("{", start);
        if (startIndex == -1) {
            return text.toString();
        }
        int endIndex = text.indexOf("}", startIndex) + 1;
        String expression = text.substring(startIndex + 1, endIndex - 1);
        String[] strokes = expression.split(" ");
        String key = strokes[0];
        IconFontDescriptorWrapper iconFontDescriptor = null;
        Icon icon = null;
        for (int i = 0; i < iconFontDescriptors.size() && (icon = (iconFontDescriptor = iconFontDescriptors.get(i)).getIcon(key)) == null; ++i) {
        }
        if (icon == null) {
            return ParsingUtil.recursivePrepareSpannableIndexes(context, fullText, text, iconFontDescriptors, accumulator, endIndex);
        }
        float iconSizePx = -1.0f;
        int iconColor = Integer.MAX_VALUE;
        float iconSizeRatio = -1.0f;
        for (int i = 1; i < strokes.length; ++i) {
            String stroke = strokes[i];
            if (stroke.matches("([0-9]*(\\.[0-9]*)?)dp")) {
                iconSizePx = ParsingUtil.dpToPx(context, Float.valueOf(stroke.substring(0, stroke.length() - 2)).floatValue());
                continue;
            }
            if (stroke.matches("([0-9]*(\\.[0-9]*)?)sp")) {
                iconSizePx = ParsingUtil.spToPx(context, Float.valueOf(stroke.substring(0, stroke.length() - 2)).floatValue());
                continue;
            }
            if (stroke.matches("([0-9]*)px")) {
                iconSizePx = Integer.valueOf(stroke.substring(0, stroke.length() - 2)).intValue();
                continue;
            }
            if (stroke.matches("@dimen/(.*)")) {
                iconSizePx = ParsingUtil.getPxFromDimen(context, stroke.substring(7));
                if (!(iconSizePx < 0.0f)) continue;
                throw new IllegalArgumentException("Unknown resource " + stroke + " in \"" + fullText + "\"");
            }
            if (stroke.matches("([0-9]*(\\.[0-9]*)?)%")) {
                iconSizeRatio = Float.valueOf(stroke.substring(0, stroke.length() - 1)).floatValue() / 100.0f;
                continue;
            }
            if (stroke.matches("#([0-9A-Fa-f]{6}|[0-9A-Fa-f]{8})")) {
                iconColor = Color.parseColor((String)stroke);
                continue;
            }
            if (stroke.matches("@color/(.*)")) {
                iconColor = ParsingUtil.getColorFromResource(context, stroke.substring(7));
                if (iconColor != Integer.MAX_VALUE) continue;
                throw new IllegalArgumentException("Unknown resource " + stroke + " in \"" + fullText + "\"");
            }
            throw new IllegalArgumentException("Unknown expression " + stroke + " in \"" + fullText + "\"");
        }
        text = text.replace(startIndex, endIndex, "" + icon.character());
        accumulator.put(startIndex, (Object)new CustomTypefaceSpan(iconFontDescriptor.getIconFontDescriptor().ttfFileName(), iconFontDescriptor.getTypeface(context), iconSizePx, iconSizeRatio, iconColor));
        return ParsingUtil.recursivePrepareSpannableIndexes(context, fullText, text, iconFontDescriptors, accumulator, startIndex);
    }

    public static float getPxFromDimen(Context context, String resName) {
        Resources resources = context.getResources();
        int resId = resources.getIdentifier(resName, "dimen", context.getPackageName());
        if (resId <= 0) {
            return -1.0f;
        }
        return resources.getDimension(resId);
    }

    public static int getColorFromResource(Context context, String resName) {
        Resources resources = context.getResources();
        int resId = resources.getIdentifier(resName, "color", context.getPackageName());
        if (resId <= 0) {
            return Integer.MAX_VALUE;
        }
        return resources.getColor(resId);
    }

    public static float dpToPx(Context context, float dp) {
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static float spToPx(Context context, float sp) {
        return TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }
}

