/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package com.jgeppert.struts2.jquery.views.jsp.ui;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.components.Component;

import com.jgeppert.struts2.jquery.components.Autocompleter;
import com.opensymphony.xwork2.util.ValueStack;

public class AutocompleterTag extends AbstractFormListElementTag
{

	private static final long	serialVersionUID	= 4675729906623010236L;

	protected String			delay;
	protected String			loadMinimumCount;
	protected String			selectBox;
	protected String			onSelectTopics;
	protected String			onFocusTopics;
	protected String			onSearchTopics;
	protected String			maxlength;
	protected String			readonly;
	protected String			size;
	protected String			multiple;

	public Component getBean(ValueStack stack, HttpServletRequest req, HttpServletResponse res) {
		return new Autocompleter(stack, req, res);
	}

	protected void populateParams() {
		super.populateParams();

		Autocompleter completer = (Autocompleter) component;
		completer.setDelay(delay);
		completer.setLoadMinimumCount(loadMinimumCount);
		completer.setSelectBox(selectBox);
		completer.setOnSelectTopics(onSelectTopics);
		completer.setOnFocusTopics(onFocusTopics);
		completer.setOnSearchTopics(onSearchTopics);
		completer.setMaxlength(maxlength);
		completer.setReadonly(readonly);
		completer.setSize(size);
		completer.setMultiple(multiple);
	}

	public void setMaxlength(String maxlength) {
		this.maxlength = maxlength;
	}

	public void setReadonly(String readonly) {
		this.readonly = readonly;
	}

	public void setSize(String size) {
		this.size = size;
	}

	public void setDelay(String delay) {
		this.delay = delay;
	}

	public void setLoadMinimumCount(String loadMinimumCount) {
		this.loadMinimumCount = loadMinimumCount;
	}

	public void setSelectBox(String selectBox) {
		this.selectBox = selectBox;
	}

	public void setOnSelectTopics(String onSelectTopics) {
		this.onSelectTopics = onSelectTopics;
	}

	public void setOnFocusTopics(String onFocusTopics) {
		this.onFocusTopics = onFocusTopics;
	}

	public void setOnSearchTopics(String onSearchTopics) {
		this.onSearchTopics = onSearchTopics;
	}

	public void setMultiple(String multiple) {
		this.multiple = multiple;
	}
}
